/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.client.indigo.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.fabricmc.fabric.impl.client.indigo.renderer.accessor.AccessSubmitNodeCollection;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.ItemRenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.MeshItemSubmit;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.SubmitNodeCollection;
import net.minecraft.client.renderer.feature.ItemFeatureRenderer;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemFeatureRenderer.class})
abstract class ItemFeatureRendererMixin {
    @Shadow
    @Final
    private PoseStack poseStack;
    @Unique
    private final ItemRenderContext itemRenderContext = new ItemRenderContext();

    ItemFeatureRendererMixin() {
    }

    @Inject(method={"renderSolid"}, at={@At(value="RETURN")})
    private void onReturnRenderSolid(SubmitNodeCollection nodeCollection, MultiBufferSource.BufferSource bufferSource, OutlineBufferSource outlineBufferSource, CallbackInfo ci) {
        for (MeshItemSubmit submit : ((AccessSubmitNodeCollection)nodeCollection).fabric_getMeshItemSubmits()) {
            this.poseStack.pushPose();
            this.poseStack.last().set(submit.pose());
            this.itemRenderContext.renderItem(submit.displayContext(), this.poseStack, (MultiBufferSource)bufferSource, submit.lightCoords(), submit.overlayCoords(), submit.tintLayers(), submit.quads(), submit.mesh(), submit.renderType(), submit.renderTypeGetter(), submit.foilType(), false, false);
            if (submit.outlineColor() != 0) {
                outlineBufferSource.setColor(submit.outlineColor());
                this.itemRenderContext.renderItem(submit.displayContext(), this.poseStack, (MultiBufferSource)outlineBufferSource, submit.lightCoords(), submit.overlayCoords(), submit.tintLayers(), submit.quads(), submit.mesh(), submit.renderType(), submit.renderTypeGetter(), ItemStackRenderState.FoilType.NONE, true, false);
            }
            this.poseStack.popPose();
        }
    }

    @Inject(method={"renderTranslucent"}, at={@At(value="RETURN")})
    private void onReturnRenderTranslucent(SubmitNodeCollection nodeCollection, MultiBufferSource.BufferSource bufferSource, OutlineBufferSource outlineBufferSource, CallbackInfo ci) {
        for (MeshItemSubmit submit : ((AccessSubmitNodeCollection)nodeCollection).fabric_getMeshItemSubmits()) {
            this.poseStack.pushPose();
            this.poseStack.last().set(submit.pose());
            this.itemRenderContext.renderItem(submit.displayContext(), this.poseStack, (MultiBufferSource)bufferSource, submit.lightCoords(), submit.overlayCoords(), submit.tintLayers(), submit.quads(), submit.mesh(), submit.renderType(), submit.renderTypeGetter(), submit.foilType(), false, true);
            if (submit.outlineColor() != 0) {
                outlineBufferSource.setColor(submit.outlineColor());
                this.itemRenderContext.renderItem(submit.displayContext(), this.poseStack, (MultiBufferSource)outlineBufferSource, submit.lightCoords(), submit.overlayCoords(), submit.tintLayers(), submit.quads(), submit.mesh(), submit.renderType(), submit.renderTypeGetter(), ItemStackRenderState.FoilType.NONE, true, true);
            }
            this.poseStack.popPose();
        }
    }
}

