/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.client.indigo.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.fabricmc.fabric.impl.client.indigo.renderer.accessor.AccessSubmitNodeCollection;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.ItemRenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.MeshItemSubmit;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.SubmitNodeCollection;
import net.minecraft.client.renderer.feature.ItemFeatureRenderer;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemFeatureRenderer.class})
abstract class ItemFeatureRendererMixin {
    @Shadow
    @Final
    private PoseStack poseStack;
    @Unique
    private final ItemRenderContext itemRenderContext = new ItemRenderContext();

    ItemFeatureRendererMixin() {
    }

    @Inject(method={"render"}, at={@At(value="RETURN")})
    private void onReturnRender(SubmitNodeCollection nodeCollection, MultiBufferSource.BufferSource bufferSource, OutlineBufferSource outlineBufferSource, CallbackInfo ci) {
        for (MeshItemSubmit itemSubmit : ((AccessSubmitNodeCollection)nodeCollection).fabric_getMeshItemSubmits()) {
            this.poseStack.pushPose();
            this.poseStack.last().set(itemSubmit.positionMatrix());
            this.itemRenderContext.renderItem(itemSubmit.displayContext(), this.poseStack, (MultiBufferSource)bufferSource, itemSubmit.lightCoords(), itemSubmit.overlayCoords(), itemSubmit.tintLayers(), itemSubmit.quads(), itemSubmit.mesh(), itemSubmit.renderType(), itemSubmit.renderTypeGetter(), itemSubmit.foilType(), false);
            if (itemSubmit.outlineColor() != 0) {
                outlineBufferSource.setColor(itemSubmit.outlineColor());
                this.itemRenderContext.renderItem(itemSubmit.displayContext(), this.poseStack, (MultiBufferSource)outlineBufferSource, itemSubmit.lightCoords(), itemSubmit.overlayCoords(), itemSubmit.tintLayers(), itemSubmit.quads(), itemSubmit.mesh(), itemSubmit.renderType(), itemSubmit.renderTypeGetter(), ItemStackRenderState.FoilType.NONE, true);
            }
            this.poseStack.popPose();
        }
    }
}

