/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.rendering.data.client;

import java.util.HashMap;
import java.util.Map;

import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachmentBlockEntity;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2818;
import net.minecraft.class_853;

@Mixin(class_853.class)
public abstract class MixinChunkRendererRegion implements RenderAttachedBlockView {
    private HashMap<class_2338, Object> fabric_renderDataObjects;

    @Inject(at = @At("RETURN"), method = "<init>")
    public void init(class_1937 world, int cxOff, int czOff, class_2818[][] chunks, class_2338 posFrom, class_2338 posTo, CallbackInfo info) {
        HashMap<class_2338, Object> map = new HashMap<>();

        for (class_2818[] chunkA : chunks) {
            for (class_2818 chunkB : chunkA) {
                for (Map.Entry<class_2338, class_2586> entry: chunkB.method_12214().entrySet()) {
                    class_2338 entPos = entry.getKey();
                    if (entPos.method_10263() >= posFrom.method_10263() && entPos.method_10263() <= posTo.method_10263()
                            && entPos.method_10264() >= posFrom.method_10264() && entPos.method_10264() <= posTo.method_10264()
                            && entPos.method_10260() >= posFrom.method_10260() && entPos.method_10260() <= posTo.method_10260()) {

                        Object o = ((RenderAttachmentBlockEntity) entry.getValue()).getRenderAttachmentData();
                        if (o != null) {
                            map.put(entPos, o);
                        }
                    }
                }
            }
        }

        this.fabric_renderDataObjects = map;
    }

    @Override
    public Object getBlockEntityRenderAttachment(class_2338 pos) {
        return fabric_renderDataObjects.get(pos);
    }
}
