/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.rendering.fluid;

import java.util.IdentityHashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.minecraft.class_1058;
import net.minecraft.class_1163;
import net.minecraft.class_1920;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2338;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5458;

public class FluidRenderHandlerRegistryImpl
implements FluidRenderHandlerRegistry {
    public static final FluidRenderHandlerRegistryImpl INSTANCE = new FluidRenderHandlerRegistryImpl();
    private static final int DEFAULT_WATER_COLOR = ((class_1959)class_5458.field_25933.method_29107(class_1972.field_9423)).method_8687();
    private final Map<class_3611, FluidRenderHandler> handlers = new IdentityHashMap<class_3611, FluidRenderHandler>();
    private final Map<class_3611, FluidRenderHandler> modHandlers = new IdentityHashMap<class_3611, FluidRenderHandler>();

    private FluidRenderHandlerRegistryImpl() {
    }

    @Override
    public FluidRenderHandler get(class_3611 fluid) {
        return this.handlers.get(fluid);
    }

    public FluidRenderHandler getOverride(class_3611 fluid) {
        return this.modHandlers.get(fluid);
    }

    @Override
    public void register(class_3611 fluid, FluidRenderHandler renderer) {
        this.handlers.put(fluid, renderer);
        this.modHandlers.put(fluid, renderer);
    }

    public void onFluidRendererReload(final class_1058[] waterSprites, final class_1058[] lavaSprites) {
        FluidRenderHandler waterHandler = new FluidRenderHandler(){

            @Override
            public class_1058[] getFluidSprites(class_1920 view, class_2338 pos, class_3610 state) {
                return waterSprites;
            }

            @Override
            public int getFluidColor(class_1920 view, class_2338 pos, class_3610 state) {
                if (view != null && pos != null) {
                    return class_1163.method_4961((class_1920)view, (class_2338)pos);
                }
                return DEFAULT_WATER_COLOR;
            }
        };
        FluidRenderHandler lavaHandler = new FluidRenderHandler(){

            @Override
            public class_1058[] getFluidSprites(class_1920 view, class_2338 pos, class_3610 state) {
                return lavaSprites;
            }
        };
        this.register((class_3611)class_3612.field_15910, waterHandler);
        this.register((class_3611)class_3612.field_15909, waterHandler);
        this.register((class_3611)class_3612.field_15908, lavaHandler);
        this.register((class_3611)class_3612.field_15907, lavaHandler);
        this.handlers.putAll(this.modHandlers);
    }
}

