/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.client.rendering.fluid;

import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Definitions;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.impl.client.rendering.fluid.FluidRenderHandlerInfo;
import net.fabricmc.fabric.impl.client.rendering.fluid.FluidRenderHandlerRegistryImpl;
import net.fabricmc.fabric.impl.client.rendering.fluid.FluidRenderingImpl;
import net.minecraft.client.renderer.block.LiquidBlockRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LiquidBlockRenderer.class})
public class LiquidBlockRendererMixin {
    @Shadow
    @Final
    private TextureAtlasSprite waterOverlay;
    @Shadow
    @Final
    private TextureAtlasSprite waterStill;
    @Shadow
    @Final
    private TextureAtlasSprite waterFlowing;
    @Shadow
    @Final
    private TextureAtlasSprite lavaStill;
    @Shadow
    @Final
    private TextureAtlasSprite lavaFlowing;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void onResourceReloadReturn(CallbackInfo info) {
        LiquidBlockRenderer self = (LiquidBlockRenderer)this;
        ((FluidRenderHandlerRegistryImpl)FluidRenderHandlerRegistry.INSTANCE).onFluidRendererReload(self, new TextureAtlasSprite[]{this.waterStill, this.waterFlowing, this.waterOverlay}, new TextureAtlasSprite[]{this.lavaStill, this.lavaFlowing}, this.waterOverlay);
    }

    @Inject(method={"tesselate"}, at={@At(value="HEAD")}, cancellable=true)
    public void onHeadRender(BlockAndTintGetter view, BlockPos pos, VertexConsumer vertexConsumer, BlockState blockState, FluidState fluidState, CallbackInfo ci) {
        FluidRenderHandler handler;
        FluidRenderHandlerInfo info = FluidRenderingImpl.getCurrentInfo();
        if (info.handler == null && (handler = FluidRenderHandlerRegistry.INSTANCE.get(fluidState.getType())) != null) {
            handler.renderFluid(pos, view, vertexConsumer, blockState, fluidState);
            ci.cancel();
        }
    }

    @Unique
    private TextureAtlasSprite getOrDefault(int index, TextureAtlasSprite original) {
        FluidRenderHandlerInfo info = FluidRenderingImpl.getCurrentInfo();
        if (info.handler == null) {
            return original;
        }
        if (info.sprites.length == index - 1) {
            return original;
        }
        return info.sprites[index];
    }

    @ModifyVariable(method={"tesselate"}, at=@At(value="STORE"), ordinal=0)
    public TextureAtlasSprite modStill(TextureAtlasSprite original) {
        return this.getOrDefault(0, original);
    }

    @ModifyVariable(method={"tesselate"}, at=@At(value="STORE"), ordinal=1)
    public TextureAtlasSprite modFlowing(TextureAtlasSprite original) {
        return this.getOrDefault(1, original);
    }

    @ModifyExpressionValue(method={"tesselate"}, at={@At(value="CONSTANT", args={"intValue=16777215"}), @At(value="INVOKE", target="Lnet/minecraft/client/renderer/BiomeColors;getAverageWaterColor(Lnet/minecraft/world/level/BlockAndTintGetter;Lnet/minecraft/core/BlockPos;)I")})
    public int modTintColor(int original, BlockAndTintGetter level, BlockPos pos, VertexConsumer vertexConsumer, BlockState blockState, FluidState fluidState) {
        FluidRenderHandlerInfo info = FluidRenderingImpl.getCurrentInfo();
        return info.handler != null ? info.handler.getFluidColor(level, pos, fluidState) : original;
    }

    @ModifyVariable(method={"tesselate"}, at=@At(value="MIXINEXTRAS:EXPRESSION", ordinal=0), slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/client/renderer/block/LiquidBlockRenderer;waterOverlay:Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", opcode=180)), ordinal=2)
    @Definitions(value={@Definition(id="getU", method={"Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;getU(F)F"}), @Definition(id="sprite2", local={@Local(type=TextureAtlasSprite.class, ordinal=2)})})
    @Expression(value={"@(sprite2).getU(0.0)"})
    private TextureAtlasSprite modifyOverlaySprite(TextureAtlasSprite waterOverlay, BlockAndTintGetter level, @Local(ordinal=1) BlockPos neighborPos, @Local(ordinal=0) boolean isLava, @Local(ordinal=1) TextureAtlasSprite flowingSprite, @Share(value="useOverlay") LocalBooleanRef useOverlay) {
        FluidRenderHandlerInfo info = FluidRenderingImpl.getCurrentInfo();
        boolean hasOverlay = info.handler != null ? info.hasOverlay : !isLava;
        Block neighborBlock = level.getBlockState(neighborPos).getBlock();
        useOverlay.set(hasOverlay && FluidRenderHandlerRegistry.INSTANCE.isBlockTransparent(neighborBlock));
        if (useOverlay.get()) {
            return info.handler != null ? info.overlaySprite : this.waterOverlay;
        }
        return flowingSprite;
    }

    @ModifyExpressionValue(method={"tesselate"}, at={@At(value="MIXINEXTRAS:EXPRESSION")})
    @Definitions(value={@Definition(id="sprite2", local={@Local(type=TextureAtlasSprite.class, ordinal=2)}), @Definition(id="waterOverlaySprite", field={"Lnet/minecraft/client/renderer/block/LiquidBlockRenderer;waterOverlay:Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;"})})
    @Expression(value={"sprite2 != this.waterOverlaySprite"})
    private boolean modifyNonOverlayCheck(boolean original, @Share(value="useOverlay") LocalBooleanRef useOverlay) {
        return !useOverlay.get();
    }
}

