/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.client.render.fluid.v1;

import com.mojang.blaze3d.platform.Transparency;
import java.util.Objects;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.minecraft.client.renderer.block.BlockAndTintGetter;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.SpriteGetter;
import net.minecraft.client.resources.model.SpriteId;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.material.FluidState;
import org.jspecify.annotations.Nullable;

public class SimpleFluidRenderHandler
implements FluidRenderHandler {
    protected final SpriteId stillTexture;
    protected final SpriteId flowingTexture;
    protected final SpriteId overlayTexture;
    protected final TextureAtlasSprite[] sprites;
    protected final int tint;

    public SimpleFluidRenderHandler(SpriteId stillTexture, SpriteId flowingTexture, @Nullable SpriteId overlayTexture, int tint) {
        this.stillTexture = Objects.requireNonNull(stillTexture, "stillTexture");
        this.flowingTexture = Objects.requireNonNull(flowingTexture, "flowingTexture");
        this.overlayTexture = overlayTexture;
        this.sprites = new TextureAtlasSprite[overlayTexture == null ? 2 : 3];
        this.tint = tint;
    }

    public SimpleFluidRenderHandler(SpriteId stillTexture, SpriteId flowingTexture, SpriteId overlayTexture) {
        this(stillTexture, flowingTexture, overlayTexture, -1);
    }

    public SimpleFluidRenderHandler(SpriteId stillTexture, SpriteId flowingTexture, int tint) {
        this(stillTexture, flowingTexture, null, tint);
    }

    public SimpleFluidRenderHandler(SpriteId stillTexture, SpriteId flowingTexture) {
        this(stillTexture, flowingTexture, null, -1);
    }

    public static SimpleFluidRenderHandler coloredWater(int tint) {
        return new SimpleFluidRenderHandler(ModelBakery.WATER_STILL, ModelBakery.WATER_FLOW, ModelBakery.WATER_OVERLAY, tint);
    }

    @Override
    public TextureAtlasSprite[] getFluidSprites(@Nullable BlockAndTintGetter level, @Nullable BlockPos pos, FluidState state) {
        return this.sprites;
    }

    @Override
    public ChunkSectionLayer reloadTextures(SpriteGetter spriteGetter) {
        this.sprites[0] = spriteGetter.get(this.stillTexture);
        this.sprites[1] = spriteGetter.get(this.flowingTexture);
        if (this.overlayTexture != null) {
            this.sprites[2] = spriteGetter.get(this.overlayTexture);
        }
        return ChunkSectionLayer.byTransparency((Transparency)this.sprites[0].transparency().or(this.sprites[1].transparency()));
    }

    @Override
    public int getFluidColor(@Nullable BlockAndTintGetter level, @Nullable BlockPos pos, FluidState state) {
        return this.tint;
    }
}

