/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.rendering.fluid;

import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.impl.client.rendering.fluid.FluidRenderingImpl;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.block.BlockAndTintGetter;
import net.minecraft.client.renderer.block.LiquidBlockRenderer;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.SpriteGetter;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jspecify.annotations.Nullable;

public class FluidRenderHandlerRegistryImpl
implements FluidRenderHandlerRegistry {
    private final Map<Fluid, FluidRenderHandler> handlers = new IdentityHashMap<Fluid, FluidRenderHandler>();
    private final Map<Fluid, FluidRenderHandler> modHandlers = new IdentityHashMap<Fluid, FluidRenderHandler>();
    private final Object2BooleanMap<Block> transparencyForOverlay = new Object2BooleanOpenHashMap();

    public FluidRenderHandlerRegistryImpl() {
        this.handlers.put((Fluid)Fluids.WATER, WaterRenderHandler.INSTANCE);
        this.handlers.put((Fluid)Fluids.FLOWING_WATER, WaterRenderHandler.INSTANCE);
        this.handlers.put((Fluid)Fluids.LAVA, LavaRenderHandler.INSTANCE);
        this.handlers.put((Fluid)Fluids.FLOWING_LAVA, LavaRenderHandler.INSTANCE);
    }

    @Override
    public @Nullable FluidRenderHandler get(Fluid fluid) {
        return this.handlers.get(fluid);
    }

    @Override
    public @Nullable FluidRenderHandler getOverride(Fluid fluid) {
        return this.modHandlers.get(fluid);
    }

    @Override
    public void register(Fluid fluid, FluidRenderHandler renderer) {
        this.handlers.put(fluid, renderer);
        this.modHandlers.put(fluid, renderer);
    }

    @Override
    public void setBlockTransparency(Block block, boolean transparent) {
        this.transparencyForOverlay.put((Object)block, transparent);
    }

    @Override
    public boolean isBlockTransparent(Block block) {
        return this.transparencyForOverlay.getOrDefault((Object)block, block instanceof HalfTransparentBlock || block instanceof LeavesBlock);
    }

    public Map<Fluid, ChunkSectionLayer> onFluidRendererReload(SpriteGetter spriteGetter, LiquidBlockRenderer renderer, TextureAtlasSprite[] waterSprites, TextureAtlasSprite[] lavaSprites, TextureAtlasSprite waterOverlay) {
        FluidRenderingImpl.setVanillaRenderer(renderer);
        WaterRenderHandler.INSTANCE.updateSprites(waterSprites, waterOverlay);
        LavaRenderHandler.INSTANCE.updateSprites(lavaSprites);
        IdentityHashMap<Fluid, ChunkSectionLayer> fluidChunkSectionLayers = new IdentityHashMap<Fluid, ChunkSectionLayer>();
        IdentityHashMap<FluidRenderHandler, ChunkSectionLayer> loadedHandlers = new IdentityHashMap<FluidRenderHandler, ChunkSectionLayer>();
        for (Map.Entry<Fluid, FluidRenderHandler> entry : this.handlers.entrySet()) {
            ChunkSectionLayer chunkSectionLayer = (ChunkSectionLayer)loadedHandlers.get(entry.getValue());
            if (chunkSectionLayer == null) {
                chunkSectionLayer = entry.getValue().reloadTextures(spriteGetter);
                loadedHandlers.put(entry.getValue(), chunkSectionLayer);
            }
            fluidChunkSectionLayers.put(entry.getKey(), chunkSectionLayer);
        }
        return fluidChunkSectionLayers;
    }

    private static class WaterRenderHandler
    implements FluidRenderHandler {
        public static final WaterRenderHandler INSTANCE = new WaterRenderHandler();
        private static final int DEFAULT_WATER_COLOR = 4159204;
        private final TextureAtlasSprite[] sprites = new TextureAtlasSprite[3];

        private WaterRenderHandler() {
        }

        @Override
        public TextureAtlasSprite[] getFluidSprites(@Nullable BlockAndTintGetter level, @Nullable BlockPos pos, FluidState state) {
            return this.sprites;
        }

        @Override
        public int getFluidColor(@Nullable BlockAndTintGetter level, @Nullable BlockPos pos, FluidState state) {
            if (level != null && pos != null) {
                return BiomeColors.getAverageWaterColor((BlockAndTintGetter)level, (BlockPos)pos);
            }
            return 4159204;
        }

        public void updateSprites(TextureAtlasSprite[] waterSprites, TextureAtlasSprite waterOverlay) {
            this.sprites[0] = waterSprites[0];
            this.sprites[1] = waterSprites[1];
            this.sprites[2] = waterOverlay;
        }
    }

    private static class LavaRenderHandler
    implements FluidRenderHandler {
        public static final LavaRenderHandler INSTANCE = new LavaRenderHandler();
        private TextureAtlasSprite[] sprites;

        private LavaRenderHandler() {
        }

        @Override
        public TextureAtlasSprite[] getFluidSprites(@Nullable BlockAndTintGetter level, @Nullable BlockPos pos, FluidState state) {
            return this.sprites;
        }

        public void updateSprites(TextureAtlasSprite[] lavaSprites) {
            this.sprites = lavaSprites;
        }
    }
}

