/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.client.render;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.class_1060;
import net.minecraft.class_1297;
import net.minecraft.class_3296;
import net.minecraft.class_897;
import net.minecraft.class_898;
import net.minecraft.class_918;

public class EntityRendererRegistry {
    public static final EntityRendererRegistry INSTANCE = new EntityRendererRegistry();
    private final Map<class_898, Context> renderManagerMap = new WeakHashMap<class_898, Context>();
    private final Map<Class<? extends class_1297>, Factory> renderSupplierMap = new HashMap<Class<? extends class_1297>, Factory>();

    private EntityRendererRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(class_898 manager, class_1060 textureManager, class_3296 resourceManager, class_918 itemRenderer, Map<Class<? extends class_1297>, class_897<? extends class_1297>> map) {
        Map<Class<? extends class_1297>, Factory> map2 = this.renderSupplierMap;
        synchronized (map2) {
            if (this.renderManagerMap.containsKey(manager)) {
                return;
            }
            Context context = new Context(textureManager, resourceManager, itemRenderer, map);
            this.renderManagerMap.put(manager, context);
            for (Class<? extends class_1297> c : this.renderSupplierMap.keySet()) {
                map.put(c, this.renderSupplierMap.get(c).create(manager, context));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Class<? extends class_1297> entityClass, Factory factory) {
        Map<Class<? extends class_1297>, Factory> map = this.renderSupplierMap;
        synchronized (map) {
            this.renderSupplierMap.put(entityClass, factory);
            for (class_898 manager : this.renderManagerMap.keySet()) {
                this.renderManagerMap.get(manager).rendererMap.put(entityClass, factory.create(manager, this.renderManagerMap.get(manager)));
            }
        }
    }

    public static final class Context {
        private final class_1060 textureManager;
        private final class_3296 resourceManager;
        private final class_918 itemRenderer;
        private final Map<Class<? extends class_1297>, class_897<? extends class_1297>> rendererMap;

        private Context(class_1060 textureManager, class_3296 resourceManager, class_918 itemRenderer, Map<Class<? extends class_1297>, class_897<? extends class_1297>> rendererMap) {
            this.textureManager = textureManager;
            this.resourceManager = resourceManager;
            this.itemRenderer = itemRenderer;
            this.rendererMap = rendererMap;
        }

        public class_1060 getTextureManager() {
            return this.textureManager;
        }

        public class_3296 getResourceManager() {
            return this.resourceManager;
        }

        public class_918 getItemRenderer() {
            return this.itemRenderer;
        }
    }

    @FunctionalInterface
    public static interface Factory {
        public class_897<? extends class_1297> create(class_898 var1, Context var2);
    }
}

