/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.client.render;

import net.fabricmc.fabric.api.client.render.EntityRendererRegistry;
import net.minecraft.class_1060;
import net.minecraft.class_1297;
import net.minecraft.class_3296;
import net.minecraft.class_897;
import net.minecraft.class_898;
import net.minecraft.class_918;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Map;

@Mixin(class_898.class)
public class MixinEntityRenderManager {
	@Shadow
	private Map<Class<? extends class_1297>, class_897<? extends class_1297>> renderers;

	@Inject(method = "<init>(Lnet/minecraft/client/texture/TextureManager;Lnet/minecraft/client/render/item/ItemRenderer;Lnet/minecraft/resource/ReloadableResourceManager;)V", at = @At("RETURN"), require = 0)
	public void init(class_1060 textureManager, class_918 itemRenderer, class_3296 manager, CallbackInfo info) {
		EntityRendererRegistry.INSTANCE.initialize((class_898) (Object) this, textureManager, manager, itemRenderer, renderers);
	}
}
