/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.client.render;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2586;
import net.minecraft.class_824;
import net.minecraft.class_827;

/**
 * Helper class for registering BlockEntityRenderers.
 */
public class BlockEntityRendererRegistry {
	public static final BlockEntityRendererRegistry INSTANCE = new BlockEntityRendererRegistry();
	private Map<Class<? extends class_2586>, class_827<? extends class_2586>> renderers = null;
	private Map<Class<? extends class_2586>, class_827<? extends class_2586>> renderersTmp = new HashMap<>();

	private BlockEntityRendererRegistry() {

	}

	public void initialize(class_824 instance, Map<Class<? extends class_2586>, class_827<? extends class_2586>> map) {
		if (renderers != null && renderers != map) {
			throw new RuntimeException("Tried to set renderers twice!");
		}

		if (renderers == map) {
			return;
		}

		renderers = map;
		for (class_827 renderer : renderersTmp.values()) {
			renderer.method_3568(instance);
		}
		renderers.putAll(renderersTmp);
		renderersTmp = null;
	}

	public void register(Class<? extends class_2586> blockEntityClass, class_827<? extends class_2586> blockEntityRenderer) {
		// TODO: warn on duplicate
		if (renderers != null) {
			renderers.put(blockEntityClass, blockEntityRenderer);
			blockEntityRenderer.method_3568(class_824.field_4346);
		} else {
			renderersTmp.put(blockEntityClass, blockEntityRenderer);
		}
	}
}
