/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.client.render;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.class_1060;
import net.minecraft.class_1297;
import net.minecraft.class_3296;
import net.minecraft.class_897;
import net.minecraft.class_898;
import net.minecraft.class_918;

/**
 * Helper class for registering EntityRenderers.
 */
public class EntityRendererRegistry {
	@FunctionalInterface
	public interface Factory {
		class_897<? extends class_1297> create(class_898 manager, EntityRendererRegistry.Context context);
	}

	public static final class Context {
		private final class_1060 textureManager;
		private final class_3296 resourceManager;
		private final class_918 itemRenderer;
		private final Map<Class<? extends class_1297>, class_897<? extends class_1297>> rendererMap;

		private Context(class_1060 textureManager, class_3296 resourceManager, class_918 itemRenderer, Map<Class<? extends class_1297>, class_897<? extends class_1297>> rendererMap) {
			this.textureManager = textureManager;
			this.resourceManager = resourceManager;
			this.itemRenderer = itemRenderer;
			this.rendererMap = rendererMap;
		}

		public class_1060 getTextureManager() {
			return textureManager;
		}

		public class_3296 getResourceManager() {
			return resourceManager;
		}

		public class_918 getItemRenderer() {
			return itemRenderer;
		}
	}

	public static final EntityRendererRegistry INSTANCE = new EntityRendererRegistry();
	private final Map<class_898, Context> renderManagerMap = new WeakHashMap<>();
	private final Map<Class<? extends class_1297>, EntityRendererRegistry.Factory> renderSupplierMap = new HashMap<>();

	private EntityRendererRegistry() { }

	public void initialize(class_898 manager, class_1060 textureManager, class_3296 resourceManager, class_918 itemRenderer, Map<Class<? extends class_1297>, class_897<? extends class_1297>> map) {
		synchronized (renderSupplierMap) {
			if (renderManagerMap.containsKey(manager)) {
				return;
			}

			Context context = new Context(textureManager, resourceManager, itemRenderer, map);
			renderManagerMap.put(manager, context);

			for (Class<? extends class_1297> c : renderSupplierMap.keySet()) {
				map.put(c, renderSupplierMap.get(c).create(manager, context));
			}
		}
	}

	public void register(Class<? extends class_1297> entityClass, EntityRendererRegistry.Factory factory) {
		synchronized (renderSupplierMap) {
			// TODO: warn on duplicate
			renderSupplierMap.put(entityClass, factory);

			for (class_898 manager : renderManagerMap.keySet()) {
				renderManagerMap.get(manager).rendererMap.put(entityClass, factory.create(manager, renderManagerMap.get(manager)));
			}
		}
	}
}
