/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.client.rendering;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.DimensionRenderingRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.InvalidateRenderStateCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.impl.client.rendering.WorldRenderContextImpl;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4063;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4599;
import net.minecraft.class_4604;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_9779;
import net.minecraft.class_9909;
import net.minecraft.class_9916;
import net.minecraft.class_9922;
import net.minecraft.class_9958;
import net.minecraft.class_9960;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_761.class})
public abstract class WorldRendererMixin {
    @Final
    @Shadow
    private class_4599 field_20951;
    @Shadow
    private class_638 field_4085;
    @Final
    @Shadow
    private class_310 field_4088;
    @Shadow
    @Final
    private class_9960 field_53081;
    @Unique
    private final WorldRenderContextImpl context = new WorldRenderContextImpl();

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void beforeRender(class_9922 objectAllocator, class_9779 tickCounter, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, Matrix4f positionMatrix, Matrix4f projectionMatrix, CallbackInfo ci) {
        this.context.prepare((class_761)this, tickCounter, renderBlockOutline, camera, gameRenderer, projectionMatrix, positionMatrix, (class_4597)this.field_20951.method_23000(), class_310.method_29611(), this.field_4085);
        ((WorldRenderEvents.Start)WorldRenderEvents.START.invoker()).onStart(this.context);
    }

    @Inject(method={"setupTerrain"}, at={@At(value="RETURN")})
    private void afterTerrainSetup(class_4184 camera, class_4604 frustum, boolean hasForcedFrustum, boolean spectator, CallbackInfo ci) {
        this.context.setFrustum(frustum);
    }

    @Inject(method={"method_62214"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiler/Profiler;push(Ljava/lang/String;)V", args={"ldc=terrain"}, shift=At.Shift.AFTER)})
    private void beforeTerrainSolid(CallbackInfo ci) {
        ((WorldRenderEvents.AfterSetup)WorldRenderEvents.AFTER_SETUP.invoker()).afterSetup(this.context);
    }

    @Inject(method={"method_62214"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/WorldRenderer;renderLayer(Lnet/minecraft/client/render/RenderLayer;DDDLorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V", ordinal=2, shift=At.Shift.AFTER)})
    private void afterTerrainSolid(CallbackInfo ci) {
        ((WorldRenderEvents.BeforeEntities)WorldRenderEvents.BEFORE_ENTITIES.invoker()).beforeEntities(this.context);
    }

    @ModifyExpressionValue(method={"method_62214"}, at={@At(value="NEW", target="net/minecraft/client/util/math/MatrixStack")})
    private class_4587 setMatrixStack(class_4587 matrixStack) {
        this.context.setMatrixStack(matrixStack);
        return matrixStack;
    }

    @Inject(method={"method_62214"}, at={@At(value="CONSTANT", args={"stringValue=blockentities"}, ordinal=0)})
    private void afterEntities(CallbackInfo ci) {
        ((WorldRenderEvents.AfterEntities)WorldRenderEvents.AFTER_ENTITIES.invoker()).afterEntities(this.context);
    }

    @Inject(method={"renderTargetBlockOutline"}, at={@At(value="FIELD", target="Lnet/minecraft/client/MinecraftClient;crosshairTarget:Lnet/minecraft/util/hit/HitResult;", shift=At.Shift.AFTER, ordinal=0)})
    private void beforeRenderOutline(CallbackInfo ci) {
        this.context.renderBlockOutline = ((WorldRenderEvents.BeforeBlockOutline)WorldRenderEvents.BEFORE_BLOCK_OUTLINE.invoker()).beforeBlockOutline(this.context, this.field_4088.field_1765);
    }

    @Inject(method={"drawBlockOutline"}, at={@At(value="HEAD")}, cancellable=true)
    private void onDrawBlockOutline(class_4587 matrixStack, class_4588 vertexConsumer, class_1297 entity, double cameraX, double cameraY, double cameraZ, class_2338 blockPos, class_2680 blockState, int color, CallbackInfo ci) {
        if (!this.context.renderBlockOutline) {
            ci.cancel();
        } else {
            this.context.prepareBlockOutline(entity, cameraX, cameraY, cameraZ, blockPos, blockState);
            if (!((WorldRenderEvents.BlockOutline)WorldRenderEvents.BLOCK_OUTLINE.invoker()).onBlockOutline(this.context, this.context)) {
                ci.cancel();
            }
        }
    }

    @ModifyVariable(method={"drawBlockOutline"}, at=@At(value="HEAD"))
    private class_4588 resetBlockOutlineBuffer(class_4588 vertexConsumer) {
        return this.context.consumers().getBuffer(class_1921.method_23594());
    }

    @Inject(method={"method_62214"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/debug/DebugRenderer;render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/Frustum;Lnet/minecraft/client/render/VertexConsumerProvider$Immediate;DDD)V", ordinal=0)})
    private void beforeDebugRender(CallbackInfo ci) {
        ((WorldRenderEvents.DebugRender)WorldRenderEvents.BEFORE_DEBUG_RENDER.invoker()).beforeDebugRender(this.context);
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/option/GameOptions;getCloudRenderModeValue()Lnet/minecraft/client/option/CloudRenderMode;")})
    private void beforeClouds(CallbackInfo ci, @Local class_9909 frameGraphBuilder) {
        class_9916 afterTranslucentPass = frameGraphBuilder.method_61911("afterTranslucent");
        this.field_53081.field_53091 = afterTranslucentPass.method_61933(this.field_53081.field_53091);
        afterTranslucentPass.method_61929(() -> ((WorldRenderEvents.AfterTranslucent)WorldRenderEvents.AFTER_TRANSLUCENT.invoker()).afterTranslucent(this.context));
    }

    @Inject(method={"method_62214"}, at={@At(value="RETURN")})
    private void onFinishWritingFramebuffer(CallbackInfo ci) {
        ((WorldRenderEvents.Last)WorldRenderEvents.LAST.invoker()).onLast(this.context);
    }

    @Inject(method={"render"}, at={@At(value="RETURN")})
    private void afterRender(CallbackInfo ci) {
        ((WorldRenderEvents.End)WorldRenderEvents.END.invoker()).onEnd(this.context);
    }

    @Inject(method={"Lnet/minecraft/client/render/WorldRenderer;reload()V"}, at={@At(value="HEAD")})
    private void onReload(CallbackInfo ci) {
        ((InvalidateRenderStateCallback)InvalidateRenderStateCallback.EVENT.invoker()).onInvalidate();
    }

    @Inject(at={@At(value="HEAD")}, method={"renderWeather"}, cancellable=true)
    private void renderWeather(class_9909 frameGraphBuilder, class_243 vec3d, float f, class_9958 fog, CallbackInfo info) {
        DimensionRenderingRegistry.WeatherRenderer renderer;
        if (this.field_4088.field_1687 != null && (renderer = DimensionRenderingRegistry.getWeatherRenderer((class_5321<class_1937>)this.field_4085.method_27983())) != null) {
            renderer.render(this.context);
            info.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"renderClouds"}, cancellable=true)
    private void renderCloud(class_9909 frameGraphBuilder, Matrix4f matrix4f, Matrix4f matrix4f2, class_4063 cloudRenderMode, class_243 vec3d, float f, int i, float g, CallbackInfo info) {
        DimensionRenderingRegistry.CloudRenderer renderer;
        if (this.field_4088.field_1687 != null && (renderer = DimensionRenderingRegistry.getCloudRenderer((class_5321<class_1937>)this.field_4085.method_27983())) != null) {
            renderer.render(this.context);
            info.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"renderSky"}, cancellable=true)
    private void renderSky(class_9909 frameGraphBuilder, class_4184 camera, float tickDelta, class_9958 fog, CallbackInfo info) {
        DimensionRenderingRegistry.SkyRenderer renderer;
        if (this.field_4088.field_1687 != null && (renderer = DimensionRenderingRegistry.getSkyRenderer((class_5321<class_1937>)this.field_4085.method_27983())) != null) {
            renderer.render(this.context);
            info.cancel();
        }
    }
}

