/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.client.rendering;

import java.util.function.BooleanSupplier;
import net.minecraft.class_332;
import net.minecraft.class_9080;
import net.minecraft.class_9779;

/**
 * A layer that wraps another layered drawer that can be added to {@link net.fabricmc.fabric.api.client.rendering.v1.LayeredDrawerWrapper LayeredDrawerWrapper}.
 *
 * <p>This wraps the vanilla sub drawers, so we can retrieve sub layers as needed in the layered drawer wrapper.
 *
 * @param delegate     the layered drawer to wrap
 * @param shouldRender a boolean supplier that determines if the layer should render
 */
public record SubLayer(class_9080 delegate, BooleanSupplier shouldRender) implements class_9080.class_9081 {
	@Override
	public void render(class_332 context, class_9779 tickCounter) {
		if (shouldRender.getAsBoolean()) {
			delegate.method_55809(context, tickCounter);
		}
	}
}
