/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.client.rendering.v1;

import net.fabricmc.fabric.impl.client.rendering.WrappedLayer;
import net.minecraft.class_2960;
import net.minecraft.class_9080;

/**
 * A hud layer that has an identifier attached for use in {@link LayeredDrawerWrapper}.
 *
 * <p>The identifiers in this interface are the vanilla hud layers in the order they are drawn in.
 * The first layer is drawn first, which means it is at the bottom.
 * All vanilla layers except {@link #SLEEP} are in sub drawers and have a render condition attached ({@link net.minecraft.class_315#field_1842}).
 * Operations relative to any layer will generally inherit that layer's render condition.
 * There is currently no mechanism to change the render condition of a layer.
 *
 * <p>For common use cases and more details on how this API deals with render condition, see {@link LayeredDrawerWrapper}.
 */
public interface IdentifiedLayer extends class_9080.class_9081 {
	/**
	 * The identifier for the vanilla miscellaneous overlays (such as vignette, spyglass, and powder snow) layer.
	 */
	class_2960 MISC_OVERLAYS = class_2960.method_60656("misc_overlays");
	/**
	 * The identifier for the vanilla crosshair layer.
	 */
	class_2960 CROSSHAIR = class_2960.method_60656("crosshair");
	/**
	 * The identifier for the vanilla hotbar, spectator hud, experience bar, and status bars layer.
	 */
	class_2960 HOTBAR_AND_BARS = class_2960.method_60656("hotbar_and_bars");
	/**
	 * The identifier for the vanilla experience level layer.
	 */
	class_2960 EXPERIENCE_LEVEL = class_2960.method_60656("experience_level");
	/**
	 * The identifier for the vanilla status effects layer.
	 */
	class_2960 STATUS_EFFECTS = class_2960.method_60656("status_effects");
	/**
	 * The identifier for the vanilla boss bar layer.
	 */
	class_2960 BOSS_BAR = class_2960.method_60656("boss_bar");
	/**
	 * The identifier for the vanilla sleep overlay layer.
	 */
	class_2960 SLEEP = class_2960.method_60656("sleep");
	/**
	 * The identifier for the vanilla demo timer layer.
	 */
	class_2960 DEMO_TIMER = class_2960.method_60656("demo_timer");
	/**
	 * The identifier for the vanilla debug hud layer.
	 */
	class_2960 DEBUG = class_2960.method_60656("debug");
	/**
	 * The identifier for the vanilla scoreboard layer.
	 */
	class_2960 SCOREBOARD = class_2960.method_60656("scoreboard");
	/**
	 * The identifier for the vanilla overlay message layer.
	 */
	class_2960 OVERLAY_MESSAGE = class_2960.method_60656("overlay_message");
	/**
	 * The identifier for the vanilla title and subtitle layer.
	 *
	 * <p>Note that this is not the sound subtitles.
	 */
	class_2960 TITLE_AND_SUBTITLE = class_2960.method_60656("title_and_subtitle");
	/**
	 * The identifier for the vanilla chat layer.
	 */
	class_2960 CHAT = class_2960.method_60656("chat");
	/**
	 * The identifier for the vanilla player list layer.
	 */
	class_2960 PLAYER_LIST = class_2960.method_60656("player_list");
	/**
	 * The identifier for the vanilla sound subtitles layer.
	 */
	class_2960 SUBTITLES = class_2960.method_60656("subtitles");

	/**
	 * @return the identifier of the layer
	 */
	class_2960 id();

	/**
	 * Wraps a hud layer in an identified layer.
	 *
	 * @param id    the identifier to give the layer
	 * @param layer the layer to wrap
	 * @return the identified layer
	 */
	static IdentifiedLayer of(class_2960 id, class_9080.class_9081 layer) {
		return new WrappedLayer(id, layer);
	}
}
