/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.rendering;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.DimensionRenderingRegistry;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5294;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class DimensionRenderingRegistryImpl {
    private static final Map<class_5321<class_1937>, DimensionRenderingRegistry.SkyRenderer> SKY_RENDERERS = new IdentityHashMap<class_5321<class_1937>, DimensionRenderingRegistry.SkyRenderer>();
    private static final Map<class_5321<class_1937>, DimensionRenderingRegistry.CloudRenderer> CLOUD_RENDERERS = new IdentityHashMap<class_5321<class_1937>, DimensionRenderingRegistry.CloudRenderer>();
    private static final Map<class_5321<class_1937>, DimensionRenderingRegistry.WeatherRenderer> WEATHER_RENDERERS = new IdentityHashMap<class_5321<class_1937>, DimensionRenderingRegistry.WeatherRenderer>();

    public static void registerSkyRenderer(class_5321<class_1937> key, DimensionRenderingRegistry.SkyRenderer renderer) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(renderer);
        SKY_RENDERERS.putIfAbsent(key, renderer);
    }

    public static void registerWeatherRenderer(class_5321<class_1937> key, DimensionRenderingRegistry.WeatherRenderer renderer) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(renderer);
        WEATHER_RENDERERS.putIfAbsent(key, renderer);
    }

    public static void registerDimensionEffects(class_2960 key, class_5294 effects) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(effects);
        throw new UnsupportedOperationException("Not supported in 25w14craftmine");
    }

    public static void registerCloudRenderer(class_5321<class_1937> key, DimensionRenderingRegistry.CloudRenderer renderer) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(renderer);
        CLOUD_RENDERERS.putIfAbsent(key, renderer);
    }

    @Nullable
    public static DimensionRenderingRegistry.SkyRenderer getSkyRenderer(class_5321<class_1937> key) {
        return SKY_RENDERERS.get(key);
    }

    @Nullable
    public static DimensionRenderingRegistry.CloudRenderer getCloudRenderer(class_5321<class_1937> key) {
        return CLOUD_RENDERERS.get(key);
    }

    @Nullable
    public static DimensionRenderingRegistry.WeatherRenderer getWeatherRenderer(class_5321<class_1937> key) {
        return WEATHER_RENDERERS.get(key);
    }

    @Nullable
    public static class_5294 getDimensionEffects(class_2960 key) {
        throw new UnsupportedOperationException("Not supported in 25w14craftmine");
    }
}

