/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.client.rendering;

import java.util.function.BooleanSupplier;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.impl.client.rendering.SubLayer;
import net.minecraft.class_9080;

@Mixin(class_9080.class)
public abstract class LayeredDrawerMixin {
	@Shadow
	public abstract class_9080 addLayer(class_9080.class_9081 layer);

	@Inject(method = "addSubDrawer", at = @At("HEAD"), cancellable = true)
	private void wrapSubDrawer(class_9080 drawer, BooleanSupplier shouldRender, CallbackInfoReturnable<class_9080> cir) {
		addLayer(new SubLayer(drawer, shouldRender));
		cir.setReturnValue((class_9080) (Object) this);
	}
}
