/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.rendering;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.SpecialGuiElementRegistry;
import net.minecraft.class_11239;
import net.minecraft.class_11256;
import net.minecraft.class_310;
import net.minecraft.class_4597;

@Environment(value=EnvType.CLIENT)
public final class SpecialGuiElementRegistryImpl {
    private static RegistrationHandler registrationHandler = new EarlyRegistrationHandler();

    private SpecialGuiElementRegistryImpl() {
    }

    public static void register(SpecialGuiElementRegistry.Factory factory) {
        registrationHandler.register(factory);
    }

    public static void onReady(class_310 client, class_4597.class_4598 immediate, Map<Class<? extends class_11256>, class_11239<?>> specialElementRenderers) {
        RegistrationHandler registrationHandler = SpecialGuiElementRegistryImpl.registrationHandler;
        Objects.requireNonNull(registrationHandler);
        RegistrationHandler registrationHandler2 = registrationHandler;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EarlyRegistrationHandler.class, LateRegistrationHandler.class}, (Object)registrationHandler2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                EarlyRegistrationHandler handler = (EarlyRegistrationHandler)registrationHandler2;
                SpecialGuiElementRegistryImpl.registrationHandler = handler.onCreated(client, immediate, specialElementRenderers);
                break;
            }
            case 1: {
                LateRegistrationHandler handler = (LateRegistrationHandler)registrationHandler2;
                throw new IllegalStateException("Already transitioned to late registration handler");
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static sealed interface RegistrationHandler
    permits EarlyRegistrationHandler, LateRegistrationHandler {
        public void register(SpecialGuiElementRegistry.Factory var1);

        default public void applyFactory(SpecialGuiElementRegistry.Factory factory, SpecialGuiElementRegistry.Context context, Map<Class<? extends class_11256>, class_11239<?>> specialElementRenderers) {
            class_11239<?> elementRenderer = factory.createSpecialRenderer(context);
            specialElementRenderers.put(elementRenderer.method_70903(), elementRenderer);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static final class EarlyRegistrationHandler
    implements RegistrationHandler {
        private List<SpecialGuiElementRegistry.Factory> pendingFactories = new ArrayList<SpecialGuiElementRegistry.Factory>();

        private EarlyRegistrationHandler() {
        }

        @Override
        public void register(SpecialGuiElementRegistry.Factory factory) {
            this.pendingFactories.add(factory);
        }

        public LateRegistrationHandler onCreated(class_310 client, class_4597.class_4598 immediate, Map<Class<? extends class_11256>, class_11239<?>> specialElementRenderers) {
            ContextImpl context = new ContextImpl(client, immediate);
            for (SpecialGuiElementRegistry.Factory factory : this.pendingFactories) {
                this.applyFactory(factory, context, specialElementRenderers);
            }
            return new LateRegistrationHandler(context, specialElementRenderers);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private record LateRegistrationHandler(SpecialGuiElementRegistry.Context context, Map<Class<? extends class_11256>, class_11239<?>> specialElementRenderers) implements RegistrationHandler
    {
        @Override
        public void register(SpecialGuiElementRegistry.Factory factory) {
            this.applyFactory(factory, this.context, this.specialElementRenderers);
        }
    }

    @Environment(value=EnvType.CLIENT)
    record ContextImpl(class_310 client, class_4597.class_4598 vertexConsumers) implements SpecialGuiElementRegistry.Context
    {
    }
}

