/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.client.rendering;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11239;
import net.minecraft.class_11256;
import net.minecraft.class_11684;
import net.minecraft.class_310;
import net.minecraft.class_4597;

public final class SpecialGuiElementRendererPool<T extends class_11256> implements AutoCloseable {
	private int index = 0;
	private final List<class_11239<T>> renderers = new ArrayList<>();

	public void newFrame() {
		index = 0;
	}

	public class_11239<T> substitute(class_11239<T> original, T elementState, class_310 client, class_4597.class_4598 immediate, class_11684 entityRenderDispatcher) {
		int index = this.index++;

		if (index == 0) {
			return original;
		} else if (index <= renderers.size()) {
			return renderers.get(index - 1);
		} else {
			class_11239<T> newRenderer = SpecialGuiElementRegistryImpl.createNewRenderer(elementState, client, immediate, entityRenderDispatcher);

			if (newRenderer == null) {
				// This renderer has been registered in an unofficial way (using mixins rather than through FAPI).
				// We don't have a factory to create a new renderer, so don't fix in this case.
				return original;
			}

			renderers.add(newRenderer);
			return newRenderer;
		}
	}

	public void cleanUpUnusedRenderers() {
		int firstUnusedIndex = Math.max(0, index - 1);

		if (firstUnusedIndex >= renderers.size()) {
			return;
		}

		for (int i = firstUnusedIndex; i < renderers.size(); i++) {
			renderers.get(i).close();
		}

		renderers.subList(firstUnusedIndex, renderers.size()).clear();
	}

	@Override
	public void close() {
		renderers.forEach(class_11239::close);

		index = 0;
		renderers.clear();
	}
}
