/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.client.rendering;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.client.rendering.GuiRendererExtensions;
import net.fabricmc.fabric.impl.client.rendering.SpecialGuiElementRegistryImpl;
import net.fabricmc.fabric.impl.client.rendering.SpecialGuiElementRendererPool;
import net.minecraft.class_11228;
import net.minecraft.class_11239;
import net.minecraft.class_11246;
import net.minecraft.class_11256;
import net.minecraft.class_11659;
import net.minecraft.class_11684;
import net.minecraft.class_310;
import net.minecraft.class_4597;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_11228.class})
abstract class GuiRendererMixin
implements GuiRendererExtensions {
    @Shadow
    @Final
    @Mutable
    private Map<Class<? extends class_11256>, class_11239<?>> field_59918;
    @Shadow
    @Final
    private class_4597.class_4598 field_59917;
    @Unique
    private boolean hasFabricInitialized = false;
    @Unique
    private final Map<Class<? extends class_11256>, SpecialGuiElementRendererPool<?>> rendererPools = new HashMap();
    @Unique
    private class_11684 entityRenderDispatcher = null;

    GuiRendererMixin() {
    }

    @Inject(method={"<init>(Lnet/minecraft/class_11246;Lnet/minecraft/class_4597$class_4598;Lnet/minecraft/class_11659;Lnet/minecraft/class_11684;Ljava/util/List;)V"}, at={@At(value="RETURN")})
    private void mutableSpecialElementRenderers(class_11246 state, class_4597.class_4598 vertexConsumers, class_11659 entityRenderCommandQueue, class_11684 entityRenderDispatcher, List list, CallbackInfo ci) {
        this.field_59918 = new IdentityHashMap(this.field_59918);
    }

    @Override
    public void fabric_onReady(class_11684 entityRenderDispatcher) {
        this.entityRenderDispatcher = entityRenderDispatcher;
        SpecialGuiElementRegistryImpl.onReady(class_310.method_1551(), this.field_59917, entityRenderDispatcher, this.field_59918);
        this.hasFabricInitialized = true;
    }

    @Inject(method={"method_70893()V"}, at={@At(value="HEAD")})
    private void prePrepareSpecialElements(CallbackInfo ci) {
        this.rendererPools.values().forEach(SpecialGuiElementRendererPool::newFrame);
    }

    @Inject(method={"method_70893()V"}, at={@At(value="RETURN")})
    private void postPrepareSpecialElements(CallbackInfo ci) {
        this.rendererPools.values().forEach(SpecialGuiElementRendererPool::cleanUpUnusedRenderers);
    }

    @ModifyVariable(method={"method_70888(Lnet/minecraft/class_11256;I)V"}, at=@At(value="STORE"))
    private <T extends class_11256> class_11239<T> substitueSpecialElementRenderer(class_11239<T> original, T elementState) {
        if (original == null || !this.hasFabricInitialized) {
            return original;
        }
        SpecialGuiElementRendererPool rendererPool = this.rendererPools.computeIfAbsent(original.method_70903(), k -> new SpecialGuiElementRendererPool());
        return rendererPool.substitute(original, elementState, class_310.method_1551(), this.field_59917, Objects.requireNonNull(this.entityRenderDispatcher, "renderDispatcher"));
    }

    @Inject(method={"close()V"}, at={@At(value="RETURN")})
    private void closeRendererPools(CallbackInfo ci) {
        this.rendererPools.values().forEach(SpecialGuiElementRendererPool::close);
    }
}

