/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.rendering;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11515;
import net.minecraft.class_2248;
import net.minecraft.class_3611;

@Environment(value=EnvType.CLIENT)
public final class BlockRenderLayerMapImpl {
    private static final Map<class_2248, class_11515> BLOCK_RENDER_LAYER_MAP = new HashMap<class_2248, class_11515>();
    private static final Map<class_3611, class_11515> FLUID_RENDER_LAYER_MAP = new HashMap<class_3611, class_11515>();
    private static BiConsumer<class_2248, class_11515> blockHandler = BLOCK_RENDER_LAYER_MAP::put;
    private static BiConsumer<class_3611, class_11515> fluidHandler = FLUID_RENDER_LAYER_MAP::put;

    public static void putBlock(class_2248 block, class_11515 layer) {
        Objects.requireNonNull(block, "block must not be null");
        Objects.requireNonNull(layer, "render layer must not be null");
        blockHandler.accept(block, layer);
    }

    public static void putFluid(class_3611 fluid, class_11515 layer) {
        Objects.requireNonNull(fluid, "fluid must not be null");
        Objects.requireNonNull(layer, "render layer must not be null");
        fluidHandler.accept(fluid, layer);
    }

    public static void setup(BiConsumer<class_2248, class_11515> vanillaBlockHandler, BiConsumer<class_3611, class_11515> vanillaFluidHandler) {
        BLOCK_RENDER_LAYER_MAP.forEach(vanillaBlockHandler);
        FLUID_RENDER_LAYER_MAP.forEach(vanillaFluidHandler);
        blockHandler = vanillaBlockHandler;
        fluidHandler = vanillaFluidHandler;
    }

    private BlockRenderLayerMapImpl() {
    }
}

