/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.client.rendering;

import java.util.Map;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import net.fabricmc.fabric.api.client.rendering.v1.FabricRenderState;
import net.fabricmc.fabric.api.client.rendering.v1.RenderStateDataKey;
import net.minecraft.class_10017;
import net.minecraft.class_10090;
import net.minecraft.class_10444;
import net.minecraft.class_11658;
import net.minecraft.class_11791;
import net.minecraft.class_11954;
import net.minecraft.class_12074;
import net.minecraft.class_12075;
import net.minecraft.class_12076;
import net.minecraft.class_12077;
import net.minecraft.class_12078;

@Mixin({
		class_10017.class,
		class_11954.class,
		class_10444.class,
		class_10444.class_10446.class,
		class_10090.class,
		class_10090.class_10091.class,
		class_11791.class,
		class_11658.class,
		class_12075.class,
		class_12074.class,
		class_12077.class,
		class_12078.class,
		class_12076.class
})
public abstract class RenderStateMixin implements FabricRenderState {
	@Unique
	@Nullable
	private Map<RenderStateDataKey<?>, Object> renderStateData;

	@Override
	@SuppressWarnings("unchecked")
	public <T> @Nullable T getData(RenderStateDataKey<T> key) {
		return renderStateData == null ? null : (T) renderStateData.get(key);
	}

	@Override
	@SuppressWarnings("unchecked")
	public <T> T getDataOrDefault(RenderStateDataKey<T> key, T defaultValue) {
		return renderStateData == null ? defaultValue : (T) renderStateData.getOrDefault(key, defaultValue);
	}

	@Override
	public <T> void setData(RenderStateDataKey<T> key, T value) {
		if (renderStateData == null) {
			renderStateData = new Reference2ObjectOpenHashMap<>();
		}

		renderStateData.put(key, value);
	}

	@Override
	public void clearExtraData() {
		if (renderStateData != null) {
			renderStateData.clear();
		}
	}
}
