/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.client.rendering;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_10515;
import net.minecraft.class_2248;

public final class SpecialBlockRendererRegistryImpl {
	private static final Map<class_2248, class_10515.class_10516> MAP = new HashMap<>();
	private static BiConsumer<class_2248, class_10515.class_10516> handler = MAP::put;

	public static void setup(BiConsumer<class_2248, class_10515.class_10516> vanillaHandler) {
		MAP.forEach(vanillaHandler);
		handler = vanillaHandler;
	}

	public static void register(class_2248 block, class_10515.class_10516 unbakedRenderer) {
		handler.accept(block, unbakedRenderer);
	}
}
