/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.client.rendering;

import java.util.Objects;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.rendering.v1.LivingEntityFeatureRendererRegistrationCallback;
import net.minecraft.class_10017;
import net.minecraft.class_3887;
import net.minecraft.class_583;

public final class RegistrationHelperImpl implements LivingEntityFeatureRendererRegistrationCallback.RegistrationHelper {
	private final Function<class_3887<?, ?>, Boolean> delegate;

	public RegistrationHelperImpl(Function<class_3887<?, ?>, Boolean> delegate) {
		this.delegate = delegate;
	}

	@Override
	public <T extends class_10017> void register(class_3887<T, ? extends class_583<T>> featureRenderer) {
		Objects.requireNonNull(featureRenderer, "Feature renderer cannot be null");
		this.delegate.apply(featureRenderer);
	}
}
