/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.client.rendering.v1.hud;

import java.util.Objects;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElement;
import net.fabricmc.fabric.impl.client.rendering.hud.HudElementRegistryImpl;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public interface HudElementRegistry {
    public static void addFirst(class_2960 id, HudElement element) {
        Objects.requireNonNull(id, "identifier");
        Objects.requireNonNull(element, "hudElement");
        HudElementRegistryImpl.addFirst(id, element);
    }

    public static void addLast(class_2960 id, HudElement element) {
        Objects.requireNonNull(id, "identifier");
        Objects.requireNonNull(element, "hudElement");
        HudElementRegistryImpl.addLast(id, element);
    }

    public static void attachElementBefore(class_2960 beforeThis, class_2960 identifier, HudElement element) {
        Objects.requireNonNull(beforeThis, "beforeThis");
        Objects.requireNonNull(identifier, "identifier");
        Objects.requireNonNull(element, "hudElement");
        HudElementRegistryImpl.attachElementBefore(beforeThis, identifier, element);
    }

    public static void attachElementAfter(class_2960 afterThis, class_2960 identifier, HudElement element) {
        Objects.requireNonNull(afterThis, "afterThis");
        Objects.requireNonNull(identifier, "identifier");
        Objects.requireNonNull(element, "hudElement");
        HudElementRegistryImpl.attachElementAfter(afterThis, identifier, element);
    }

    public static void removeElement(class_2960 identifier) {
        Objects.requireNonNull(identifier, "identifier");
        HudElementRegistryImpl.removeElement(identifier);
    }

    public static void replaceElement(class_2960 identifier, Function<HudElement, HudElement> replacer) {
        Objects.requireNonNull(identifier, "identifier");
        Objects.requireNonNull(replacer, "replacer");
        HudElementRegistryImpl.replaceElement(identifier, replacer);
    }
}

