/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.rendering;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.client.rendering.SpecialGuiElementRegistryImpl;
import net.minecraft.class_11239;
import net.minecraft.class_11256;
import net.minecraft.class_11659;
import net.minecraft.class_310;
import net.minecraft.class_4597;

@Environment(value=EnvType.CLIENT)
public final class SpecialGuiElementRendererPool<T extends class_11256>
implements AutoCloseable {
    private int index = 0;
    private final List<class_11239<T>> renderers = new ArrayList<class_11239<T>>();

    public void newFrame() {
        this.index = 0;
    }

    public class_11239<T> substitute(class_11239<T> original, T elementState, class_310 client, class_4597.class_4598 immediate, class_11659 orderedRenderCommandQueue) {
        int index;
        if ((index = this.index++) == 0) {
            return original;
        }
        if (index <= this.renderers.size()) {
            return this.renderers.get(index - 1);
        }
        class_11239<T> newRenderer = SpecialGuiElementRegistryImpl.createNewRenderer(elementState, client, immediate, orderedRenderCommandQueue);
        if (newRenderer == null) {
            return original;
        }
        this.renderers.add(newRenderer);
        return newRenderer;
    }

    public void cleanUpUnusedRenderers() {
        int firstUnusedIndex = Math.max(0, this.index - 1);
        if (firstUnusedIndex >= this.renderers.size()) {
            return;
        }
        for (int i = firstUnusedIndex; i < this.renderers.size(); ++i) {
            this.renderers.get(i).close();
        }
        this.renderers.subList(firstUnusedIndex, this.renderers.size()).clear();
    }

    @Override
    public void close() {
        this.renderers.forEach(class_11239::close);
        this.index = 0;
        this.renderers.clear();
    }
}

