/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.client.rendering.v1;

import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.world.level.block.Block;

import net.fabricmc.fabric.impl.client.rendering.BlockColorRegistryImpl;

/**
 * The registry for {@link BlockColor}s.
 */
public final class BlockColorRegistry {
	private BlockColorRegistry() {
	}

	/**
	 * Register a block color for one or more blocks. Overriding existing registrations is allowed.
	 *
	 * <p>Mods must use this method instead of {@link BlockColors#register(BlockColor, Block...)} during mod
	 * initialization as it runs before {@link Minecraft#getBlockColors()} is available.
	 *
	 * @param color The block color.
	 * @param blocks The blocks which should be colored using the given color.
	 */
	public static void register(BlockColor color, Block... blocks) {
		BlockColorRegistryImpl.register(color, blocks);
	}
}
