/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.rendering;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public final class ChunkSectionLayerMapImpl {
    private static final Map<Block, ChunkSectionLayer> BLOCK_RENDER_LAYER_MAP = new HashMap<Block, ChunkSectionLayer>();
    private static final Map<Fluid, ChunkSectionLayer> FLUID_RENDER_LAYER_MAP = new HashMap<Fluid, ChunkSectionLayer>();
    private static BiConsumer<Block, ChunkSectionLayer> blockHandler = BLOCK_RENDER_LAYER_MAP::put;
    private static BiConsumer<Fluid, ChunkSectionLayer> fluidHandler = FLUID_RENDER_LAYER_MAP::put;

    public static void putBlock(Block block, ChunkSectionLayer layer) {
        Objects.requireNonNull(block, "block must not be null");
        Objects.requireNonNull(layer, "render layer must not be null");
        blockHandler.accept(block, layer);
    }

    public static void putFluid(Fluid fluid, ChunkSectionLayer layer) {
        Objects.requireNonNull(fluid, "fluid must not be null");
        Objects.requireNonNull(layer, "render layer must not be null");
        fluidHandler.accept(fluid, layer);
    }

    public static void setup(BiConsumer<Block, ChunkSectionLayer> vanillaBlockHandler, BiConsumer<Fluid, ChunkSectionLayer> vanillaFluidHandler) {
        BLOCK_RENDER_LAYER_MAP.forEach(vanillaBlockHandler);
        FLUID_RENDER_LAYER_MAP.forEach(vanillaFluidHandler);
        blockHandler = vanillaBlockHandler;
        fluidHandler = vanillaFluidHandler;
    }

    private ChunkSectionLayerMapImpl() {
    }
}

