/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.rendering;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.world.level.material.Fluid;

public final class ChunkSectionLayerMapImpl {
    private static final Map<Fluid, ChunkSectionLayer> FLUID_RENDER_LAYER_MAP = new HashMap<Fluid, ChunkSectionLayer>();
    private static BiConsumer<Fluid, ChunkSectionLayer> fluidHandler = FLUID_RENDER_LAYER_MAP::put;

    public static void putFluid(Fluid fluid, ChunkSectionLayer layer) {
        Objects.requireNonNull(fluid, "fluid must not be null");
        Objects.requireNonNull(layer, "render layer must not be null");
        fluidHandler.accept(fluid, layer);
    }

    public static void setup(BiConsumer<Fluid, ChunkSectionLayer> vanillaFluidHandler) {
        FLUID_RENDER_LAYER_MAP.forEach(vanillaFluidHandler);
        fluidHandler = vanillaFluidHandler;
    }

    private ChunkSectionLayerMapImpl() {
    }
}

