/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.resource.conditions.v1;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.fabricmc.fabric.impl.resource.conditions.ResourceConditionsImpl;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3489;
import net.minecraft.class_3494;
import net.minecraft.class_3518;
import net.minecraft.class_3611;

public final class DefaultResourceConditions {
    private static final class_2960 NOT = new class_2960("fabric:not");
    private static final class_2960 AND = new class_2960("fabric:and");
    private static final class_2960 OR = new class_2960("fabric:or");
    private static final class_2960 ALL_MODS_LOADED = new class_2960("fabric:all_mods_loaded");
    private static final class_2960 ANY_MOD_LOADED = new class_2960("fabric:any_mod_loaded");
    private static final class_2960 BLOCK_TAGS_POPULATED = new class_2960("fabric:block_tags_populated");
    private static final class_2960 FLUID_TAGS_POPULATED = new class_2960("fabric:fluid_tags_populated");
    private static final class_2960 ITEM_TAGS_POPULATED = new class_2960("fabric:item_tags_populated");

    public static ConditionJsonProvider not(final ConditionJsonProvider value) {
        return new ConditionJsonProvider(){

            @Override
            public void writeParameters(JsonObject object) {
                object.add("value", (JsonElement)value.toJson());
            }

            @Override
            public class_2960 getConditionId() {
                return NOT;
            }
        };
    }

    public static ConditionJsonProvider and(ConditionJsonProvider ... values) {
        return ResourceConditionsImpl.array(AND, values);
    }

    public static ConditionJsonProvider or(ConditionJsonProvider ... values) {
        return ResourceConditionsImpl.array(OR, values);
    }

    public static ConditionJsonProvider allModsLoaded(String ... modIds) {
        return ResourceConditionsImpl.mods(ALL_MODS_LOADED, modIds);
    }

    public static ConditionJsonProvider anyModLoaded(String ... modIds) {
        return ResourceConditionsImpl.mods(ANY_MOD_LOADED, modIds);
    }

    public static ConditionJsonProvider blockTagsPopulated(class_3494.class_5123<class_2248> ... tags) {
        return ResourceConditionsImpl.tagsPopulated(BLOCK_TAGS_POPULATED, tags);
    }

    public static ConditionJsonProvider fluidTagsPopulated(class_3494.class_5123<class_3611> ... tags) {
        return ResourceConditionsImpl.tagsPopulated(FLUID_TAGS_POPULATED, tags);
    }

    public static ConditionJsonProvider itemTagsPopulated(class_3494.class_5123<class_1792> ... tags) {
        return ResourceConditionsImpl.tagsPopulated(ITEM_TAGS_POPULATED, tags);
    }

    static void init() {
    }

    private DefaultResourceConditions() {
    }

    static {
        ResourceConditions.register(NOT, object -> {
            JsonObject condition = class_3518.method_15296((JsonObject)object, (String)"value");
            return !ResourceConditions.conditionMatches(condition);
        });
        ResourceConditions.register(AND, object -> {
            JsonArray array = class_3518.method_15261((JsonObject)object, (String)"values");
            return ResourceConditions.conditionsMatch(array, true);
        });
        ResourceConditions.register(OR, object -> {
            JsonArray array = class_3518.method_15261((JsonObject)object, (String)"values");
            return ResourceConditions.conditionsMatch(array, false);
        });
        ResourceConditions.register(ALL_MODS_LOADED, object -> ResourceConditionsImpl.modsLoadedMatch(object, true));
        ResourceConditions.register(ANY_MOD_LOADED, object -> ResourceConditionsImpl.modsLoadedMatch(object, false));
        ResourceConditions.register(BLOCK_TAGS_POPULATED, object -> ResourceConditionsImpl.tagsPopulatedMatch(object, class_3481.method_15073()));
        ResourceConditions.register(FLUID_TAGS_POPULATED, object -> ResourceConditionsImpl.tagsPopulatedMatch(object, class_3486.method_34889()));
        ResourceConditions.register(ITEM_TAGS_POPULATED, object -> ResourceConditionsImpl.tagsPopulatedMatch(object, class_3489.method_15106()));
    }
}

