/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.resource.conditions;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Iterator;
import java.util.Map;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.fabricmc.fabric.impl.resource.conditions.ResourceConditionsImpl;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_4309.class})
public class JsonDataLoaderMixin {
    @Shadow
    @Final
    private String field_19380;

    @Inject(at={@At(value="RETURN")}, method={"prepare"})
    public void applyResourceConditions(class_3300 resourceManager, class_3695 profiler, CallbackInfoReturnable<Map<class_2960, JsonElement>> cir) {
        profiler.method_15396("Fabric resource conditions: %s".formatted(this.field_19380));
        Iterator it = ((Map)cir.getReturnValue()).entrySet().iterator();
        boolean debugLogEnabled = ResourceConditionsImpl.LOGGER.isDebugEnabled();
        while (it.hasNext()) {
            JsonObject obj;
            Map.Entry entry = it.next();
            JsonElement resourceData = (JsonElement)entry.getValue();
            if (!resourceData.isJsonObject() || !(obj = resourceData.getAsJsonObject()).has("fabric:load_conditions")) continue;
            boolean matched = ResourceConditions.objectMatchesConditions(obj);
            if (!matched) {
                it.remove();
            }
            if (!debugLogEnabled) continue;
            String verdict = matched ? "Allowed" : "Rejected";
            ResourceConditionsImpl.LOGGER.debug("{} resource of type {} with id {}", (Object)verdict, (Object)this.field_19380, entry.getKey());
        }
        profiler.method_15407();
    }
}

