/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.resource.conditions;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Iterator;
import java.util.Map;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.fabricmc.fabric.impl.resource.conditions.ResourceConditionsImpl;
import net.fabricmc.fabric.mixin.resource.conditions.SinglePreparationResourceReloaderMixin;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={class_4309.class})
public class JsonDataLoaderMixin
extends SinglePreparationResourceReloaderMixin {
    @Shadow
    @Final
    private String field_19380;

    @Override
    protected void fabric_applyResourceConditions(class_3300 resourceManager, class_3695 profiler, Object object) {
        profiler.method_15396("Fabric resource conditions: %s".formatted(this.field_19380));
        Iterator it = ((Map)object).entrySet().iterator();
        boolean debugLogEnabled = ResourceConditionsImpl.LOGGER.isDebugEnabled();
        while (it.hasNext()) {
            JsonObject obj;
            Map.Entry entry = it.next();
            JsonElement resourceData = (JsonElement)entry.getValue();
            if (!resourceData.isJsonObject() || !(obj = resourceData.getAsJsonObject()).has("fabric:load_conditions")) continue;
            boolean matched = ResourceConditions.objectMatchesConditions(obj);
            if (!matched) {
                it.remove();
            }
            if (!debugLogEnabled) continue;
            String verdict = matched ? "Allowed" : "Rejected";
            ResourceConditionsImpl.LOGGER.debug("{} resource of type {} with id {}", (Object)verdict, (Object)this.field_19380, entry.getKey());
        }
        profiler.method_15407();
    }
}

