/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource.conditions;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public class ResourceConditionsImpl {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Fabric Resource Conditions");

    public static ConditionJsonProvider array(final class_2960 id, final ConditionJsonProvider ... values) {
        Preconditions.checkArgument((values.length > 0 ? 1 : 0) != 0, (Object)"Must register at least one value.");
        return new ConditionJsonProvider(){

            @Override
            public class_2960 getConditionId() {
                return id;
            }

            @Override
            public void writeParameters(JsonObject object) {
                JsonArray array = new JsonArray();
                for (ConditionJsonProvider provider : values) {
                    array.add((JsonElement)provider.toJson());
                }
                object.add("values", (JsonElement)array);
            }
        };
    }

    public static ConditionJsonProvider mods(final class_2960 id, final String ... modIds) {
        Preconditions.checkArgument((modIds.length > 0 ? 1 : 0) != 0, (Object)"Must register at least one mod id.");
        return new ConditionJsonProvider(){

            @Override
            public class_2960 getConditionId() {
                return id;
            }

            @Override
            public void writeParameters(JsonObject object) {
                JsonArray array = new JsonArray();
                for (String modId : modIds) {
                    array.add(modId);
                }
                object.add("values", (JsonElement)array);
            }
        };
    }

    public static <T> ConditionJsonProvider tagsPopulated(final class_2960 id, final class_6862<T> ... tags) {
        Preconditions.checkArgument((tags.length > 0 ? 1 : 0) != 0, (Object)"Must register at least one tag.");
        return new ConditionJsonProvider(){

            @Override
            public class_2960 getConditionId() {
                return id;
            }

            @Override
            public void writeParameters(JsonObject object) {
                JsonArray array = new JsonArray();
                for (class_6862 tag : tags) {
                    array.add(tag.comp_327().toString());
                }
                object.add("values", (JsonElement)array);
            }
        };
    }

    public static boolean modsLoadedMatch(JsonObject object, boolean and) {
        JsonArray array = class_3518.method_15261((JsonObject)object, (String)"values");
        for (JsonElement element : array) {
            if (element.isJsonPrimitive()) {
                if (FabricLoader.getInstance().isModLoaded(element.getAsString()) == and) continue;
                return !and;
            }
            throw new JsonParseException("Invalid mod id entry: " + element);
        }
        return and;
    }

    public static <T> boolean tagsPopulatedMatch(JsonObject object, class_5321<? extends class_2378<T>> registryKey) {
        JsonArray array = class_3518.method_15261((JsonObject)object, (String)"values");
        for (JsonElement element : array) {
            if (element.isJsonPrimitive()) {
                class_2960 id = new class_2960(element.getAsString());
                class_6862 tag = class_6862.method_40092(registryKey, (class_2960)id);
                class_2378 registry = (class_2378)class_2378.field_11144.method_10223(registryKey.method_29177());
                if (registry.method_40252(tag)) continue;
                return false;
            }
            throw new JsonParseException("Invalid tag id entry: " + element);
        }
        return true;
    }
}

