/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.resource.conditions;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.impl.resource.conditions.ResourceConditionsImpl;
import net.minecraft.class_2170;
import net.minecraft.class_3300;
import net.minecraft.class_5350;
import net.minecraft.class_5455;
import net.minecraft.class_7699;

@Mixin(class_5350.class)
public class DataPackContentsMixin {
	/**
	 * Clear the tags captured by {@link DataPackContentsMixin}.
	 * This must happen after the resource reload is complete, to ensure that the tags remain available throughout the entire "apply" phase.
	 */
	@Inject(
			method = "refresh",
			at = @At("HEAD")
	)
	public void hookRefresh(class_5455 dynamicRegistryManager, CallbackInfo ci) {
		ResourceConditionsImpl.clearTags();
	}

	@Inject(
			method = "reload",
			at = @At("HEAD")
	)
	private static void hookReload(class_3300 manager, class_5455.class_6890 dynamicRegistryManager, class_7699 enabledFeatures, class_2170.class_5364 environment, int functionPermissionLevel, Executor prepareExecutor, Executor applyExecutor, CallbackInfoReturnable<CompletableFuture<class_5350>> cir) {
		ResourceConditionsImpl.currentFeature.set(enabledFeatures);
	}
}
