/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.resource;

import net.minecraft.class_2960;

/**
 * This class contains default keys for various Minecraft resource reload listeners.
 * <p>
 * {@link IdentifiableResourceReloadListener}
 */
public final class ResourceReloadListenerKeys {
	// client
	public static final class_2960 SOUNDS = new class_2960("minecraft:sounds");
	public static final class_2960 FONTS = new class_2960("minecraft:fonts");
	public static final class_2960 MODELS = new class_2960("minecraft:models");
	public static final class_2960 LANGUAGES = new class_2960("minecraft:languages");
	public static final class_2960 TEXTURES = new class_2960("minecraft:textures");

	// server
	public static final class_2960 TAGS = new class_2960("minecraft:tags");
	public static final class_2960 RECIPES = new class_2960("minecraft:recipes");
	public static final class_2960 ADVANCEMENTS = new class_2960("minecraft:advancements");
	public static final class_2960 FUNCTIONS = new class_2960("minecraft:functions");
	public static final class_2960 LOOT_TABLES = new class_2960("minecraft:loot_tables");

	private ResourceReloadListenerKeys() {

	}
}
