/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.resource.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import net.minecraft.class_2960;
import net.minecraft.class_3259;
import net.minecraft.class_3264;
import net.minecraft.class_3268;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_3268.class)
public class MixinDefaultResourcePack {
	@Inject(method = "findInputStream", at = @At("HEAD"), cancellable = true)
	protected void onFindInputStream(class_3264 resourceType, class_2960 identifier, CallbackInfoReturnable<InputStream> callback) {
		if (class_3268.field_14196 != null) {
			// Fall through to Vanilla logic, they have a special case here.
			return;
		}

		String path = resourceType.method_14413() + "/" + identifier.method_12836() + "/" + identifier.method_12832();
		URL found = null;

		try {
			Enumeration<URL> candidates = class_3268.class.getClassLoader().getResources(path);

			// Get the last element
			while (candidates.hasMoreElements()) {
				found = candidates.nextElement();
			}

			if (found == null || !class_3259.method_14402(new File(found.getFile()), "/" + path)) {
				// Mimics vanilla behavior

				callback.setReturnValue(null);
				return;
			}
		} catch (IOException var6) {
			// Default path
		}

		try {
			if (found != null) {
				callback.setReturnValue(found.openStream());
			}
		} catch (Exception e) {
			// Default path
		}
	}
}
