/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.resource.loader;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackUtil;
import net.fabricmc.fabric.mixin.resource.loader.MixinFormat4ResourcePack;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3268;
import net.minecraft.class_3296;
import net.minecraft.class_4729;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_310.class})
public class MixinMinecraftGame {
    @Shadow
    private class_3296 field_1745;

    private void fabric_modifyResourcePackList(List<class_3262> list) {
        ArrayList oldList = Lists.newArrayList(list);
        list.clear();
        boolean appended = false;
        for (int i = 0; i < oldList.size(); ++i) {
            class_3262 pack = (class_3262)oldList.get(i);
            list.add(pack);
            boolean isDefaultResources = pack instanceof class_3268;
            if (!isDefaultResources && pack instanceof class_4729) {
                MixinFormat4ResourcePack fixer = (MixinFormat4ResourcePack)pack;
                isDefaultResources = fixer.getParent() instanceof class_3268;
            }
            if (!isDefaultResources) continue;
            ModResourcePackUtil.appendModResourcePacks(list, class_3264.field_14188);
            appended = true;
        }
        if (!appended) {
            StringBuilder builder = new StringBuilder("Fabric could not find resource pack injection location!");
            for (class_3262 rp : oldList) {
                builder.append("\n - ").append(rp.method_14409()).append(" (").append(rp.getClass().getName()).append(")");
            }
            throw new RuntimeException(builder.toString());
        }
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Ljava/util/stream/Stream;collect(Ljava/util/stream/Collector;)Ljava/lang/Object;"))
    public Object initResources(Stream<class_3262> stream, Collector collector) {
        List<class_3262> fabricResourcePacks = stream.collect(Collectors.toList());
        this.fabric_modifyResourcePackList(fabricResourcePacks);
        return fabricResourcePacks.stream().collect(collector);
    }

    @Inject(method={"reloadResources"}, at={@At(value="INVOKE", target="Lnet/minecraft/resource/ReloadableResourceManager;beginMonitoredReload(Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture;Ljava/util/List;)Lnet/minecraft/resource/ResourceReloadMonitor;", ordinal=0)}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void reloadResources(CallbackInfoReturnable<CompletableFuture> info, CompletableFuture<Void> cf, List<class_3262> list) {
        this.fabric_modifyResourcePackList(list);
    }
}

