/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource.loader;

import com.google.common.base.Charsets;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import net.fabricmc.fabric.impl.resource.loader.ModNioResourcePack;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_155;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import org.apache.commons.io.IOUtils;

public final class ModResourcePackUtil {
    public static final int PACK_FORMAT_VERSION = class_155.method_16673().getPackVersion();

    private ModResourcePackUtil() {
    }

    public static void appendModResourcePacks(List<class_3262> packList, class_3264 type) {
        for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
            if (container.getMetadata().getType().equals("builtin")) continue;
            Path path = container.getRootPath();
            ModNioResourcePack pack = new ModNioResourcePack(container.getMetadata(), path, null);
            if (pack.method_14406(type).isEmpty()) continue;
            packList.add(pack);
        }
    }

    public static boolean containsDefault(ModMetadata info, String filename) {
        return "pack.mcmeta".equals(filename);
    }

    public static InputStream openDefault(ModMetadata info, String filename) {
        switch (filename) {
            case "pack.mcmeta": {
                String description = info.getName();
                description = description == null ? "" : description.replaceAll("\"", "\\\"");
                String pack = String.format("{\"pack\":{\"pack_format\":" + PACK_FORMAT_VERSION + ",\"description\":\"%s\"}}", description);
                return IOUtils.toInputStream((String)pack, (Charset)Charsets.UTF_8);
            }
        }
        return null;
    }

    public static String getName(ModMetadata info) {
        if (info.getName() != null) {
            return info.getName();
        }
        return "Fabric Mod \"" + info.getId() + "\"";
    }
}

