/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource.loader;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceManagerHelperImpl
implements ResourceManagerHelper {
    private static final Map<class_3264, ResourceManagerHelperImpl> registryMap = new HashMap<class_3264, ResourceManagerHelperImpl>();
    private static final Logger LOGGER = LogManager.getLogger();
    private final Set<class_2960> addedListenerIds = new HashSet<class_2960>();
    private final Set<IdentifiableResourceReloadListener> addedListeners = new LinkedHashSet<IdentifiableResourceReloadListener>();

    public static ResourceManagerHelper get(class_3264 type) {
        return registryMap.computeIfAbsent(type, t -> new ResourceManagerHelperImpl());
    }

    public static void sort(class_3264 type, List<class_3302> listeners) {
        ResourceManagerHelperImpl instance = registryMap.get(type);
        if (instance != null) {
            instance.sort(listeners);
        }
    }

    protected void sort(List<class_3302> listeners) {
        listeners.removeAll(this.addedListeners);
        ArrayList listenersToAdd = Lists.newArrayList(this.addedListeners);
        HashSet<class_2960> resolvedIds = new HashSet<class_2960>();
        for (class_3302 listener : listeners) {
            if (!(listener instanceof IdentifiableResourceReloadListener)) continue;
            resolvedIds.add(((IdentifiableResourceReloadListener)listener).getFabricId());
        }
        int lastSize = -1;
        while (listeners.size() != lastSize) {
            lastSize = listeners.size();
            Iterator it = listenersToAdd.iterator();
            while (it.hasNext()) {
                IdentifiableResourceReloadListener listener = (IdentifiableResourceReloadListener)it.next();
                if (!resolvedIds.containsAll(listener.getFabricDependencies())) continue;
                resolvedIds.add(listener.getFabricId());
                listeners.add(listener);
                it.remove();
            }
        }
        for (IdentifiableResourceReloadListener listener : listenersToAdd) {
            LOGGER.warn("Could not resolve dependencies for listener: " + listener.getFabricId() + "!");
        }
    }

    @Override
    public void registerReloadListener(IdentifiableResourceReloadListener listener) {
        if (!this.addedListenerIds.add(listener.getFabricId())) {
            LOGGER.warn("Tried to register resource reload listener " + listener.getFabricId() + " twice!");
            return;
        }
        if (!this.addedListeners.add(listener)) {
            throw new RuntimeException("Listener with previously unknown ID " + listener.getFabricId() + " already in listener set!");
        }
    }
}

