/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.resource.loader;

import java.io.File;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.minecraft.class_31;
import net.minecraft.class_3264;
import net.minecraft.class_3283;
import net.minecraft.class_3288;
import net.minecraft.server.MinecraftServer;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackCreator;

@Mixin(MinecraftServer.class)
public class MixinMinecraftServer {
	@Shadow
	private class_3283<class_3288> dataPackContainerManager;

	@Inject(method = "loadWorldDataPacks", at = @At(value = "INVOKE", target = "Lnet/minecraft/resource/ResourcePackContainerManager;addCreator(Lnet/minecraft/resource/ResourcePackCreator;)V", ordinal = 1))
	public void appendFabricDataPacks(File file, class_31 properties, CallbackInfo info) {
		dataPackContainerManager.method_14443(new ModResourcePackCreator(class_3264.field_14190));
	}
}
