/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.resource.loader;

import java.util.Collection;
import java.util.Collections;
import java.util.Locale;

import org.spongepowered.asm.mixin.Mixin;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceReloadListenerKeys;
import net.minecraft.class_1060;
import net.minecraft.class_1076;
import net.minecraft.class_1092;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_2989;
import net.minecraft.class_2991;
import net.minecraft.class_3505;
import net.minecraft.class_378;
import net.minecraft.class_4237;
import net.minecraft.class_60;
import net.minecraft.class_761;
import net.minecraft.class_776;
import net.minecraft.class_918;

public class MixinKeyedResourceReloadListener {
	@Mixin({
			/* public */
			class_4237.class, class_378.class, class_1092.class, class_1076.class, class_1060.class,
			/* private */
			class_761.class, class_776.class, class_918.class
	})
	public abstract static class Client implements IdentifiableResourceReloadListener {
		private Collection<class_2960> fabric_idDeps;
		private class_2960 fabric_id;

		@Override
		@SuppressWarnings({"ConstantConditions", "RedundantCast"})
		public Collection<class_2960> getFabricDependencies() {
			if (fabric_idDeps == null) {
				Object self = this;

				if (self instanceof class_1092 || self instanceof class_761) {
					fabric_idDeps = Collections.singletonList(ResourceReloadListenerKeys.TEXTURES);
				} else if (self instanceof class_918 || self instanceof class_776) {
					fabric_idDeps = Collections.singletonList(ResourceReloadListenerKeys.MODELS);
				} else {
					fabric_idDeps = Collections.emptyList();
				}
			}

			return fabric_idDeps;
		}

		@Override
		@SuppressWarnings({"ConstantConditions", "RedundantCast"})
		public class_2960 getFabricId() {
			if (fabric_id == null) {
				Object self = this;

				if (self instanceof class_4237) {
					fabric_id = ResourceReloadListenerKeys.SOUNDS;
				} else if (self instanceof class_378) {
					fabric_id = ResourceReloadListenerKeys.FONTS;
				} else if (self instanceof class_1092) {
					fabric_id = ResourceReloadListenerKeys.MODELS;
				} else if (self instanceof class_1076) {
					fabric_id = ResourceReloadListenerKeys.LANGUAGES;
				} else if (self instanceof class_1060) {
					fabric_id = ResourceReloadListenerKeys.TEXTURES;
				} else {
					fabric_id = new class_2960("minecraft", "private/" + self.getClass().getSimpleName().toLowerCase(Locale.ROOT));
				}
			}

			return fabric_id;
		}
	}

	@Mixin({
			/* public */
			class_1863.class, class_2989.class, class_2991.class, class_60.class, class_3505.class
			/* private */
	})
	public abstract static class Server implements IdentifiableResourceReloadListener {
		private Collection<class_2960> fabric_idDeps;
		private class_2960 fabric_id;

		@Override
		@SuppressWarnings({"ConstantConditions", "RedundantCast"})
		public Collection<class_2960> getFabricDependencies() {
			if (fabric_idDeps == null) {
				Object self = this;

				if (self instanceof class_3505) {
					fabric_idDeps = Collections.emptyList();
				} else {
					fabric_idDeps = Collections.singletonList(ResourceReloadListenerKeys.TAGS);
				}
			}

			return fabric_idDeps;
		}

		@Override
		@SuppressWarnings({"ConstantConditions", "RedundantCast"})
		public class_2960 getFabricId() {
			if (fabric_id == null) {
				Object self = this;

				if (self instanceof class_1863) {
					fabric_id = ResourceReloadListenerKeys.RECIPES;
				} else if (self instanceof class_2989) {
					fabric_id = ResourceReloadListenerKeys.ADVANCEMENTS;
				} else if (self instanceof class_2991) {
					fabric_id = ResourceReloadListenerKeys.FUNCTIONS;
				} else if (self instanceof class_60) {
					fabric_id = ResourceReloadListenerKeys.LOOT_TABLES;
				} else if (self instanceof class_3505) {
					fabric_id = ResourceReloadListenerKeys.TAGS;
				} else {
					fabric_id = new class_2960("minecraft", "private/" + self.getClass().getSimpleName().toLowerCase(Locale.ROOT));
				}
			}

			return fabric_id;
		}
	}
}
