/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.resource.loader;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.google.common.collect.Lists;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3268;
import net.minecraft.class_3296;
import net.minecraft.class_4729;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackUtil;

@Mixin(class_310.class)
public class MixinMinecraftGame {
	@Shadow
	private class_3296 resourceManager;

	private void fabric_modifyResourcePackList(List<class_3262> list) {
		List<class_3262> oldList = Lists.newArrayList(list);
		list.clear();

		boolean appended = false;

		for (int i = 0; i < oldList.size(); i++) {
			class_3262 pack = oldList.get(i);
			list.add(pack);

			boolean isDefaultResources = pack instanceof class_3268;

			if (!isDefaultResources && pack instanceof class_4729) {
				MixinClass_4729 fixer = (MixinClass_4729) pack;
				isDefaultResources = fixer.getField_21766() instanceof class_3268;
			}

			if (isDefaultResources) {
				ModResourcePackUtil.appendModResourcePacks(list, class_3264.field_14188);
				appended = true;
			}
		}

		if (!appended) {
			StringBuilder builder = new StringBuilder("Fabric could not find resource pack injection location!");

			for (class_3262 rp : oldList) {
				builder.append("\n - ").append(rp.method_14409()).append(" (").append(rp.getClass().getName()).append(")");
			}

			throw new RuntimeException(builder.toString());
		}
	}

	@Redirect(method = "<init>", at = @At(value = "INVOKE", target = "Ljava/util/stream/Stream;collect(Ljava/util/stream/Collector;)Ljava/lang/Object;"))
	public Object initResources(Stream<class_3262> stream, Collector collector) {
		List<class_3262> fabricResourcePacks = stream.collect(Collectors.toList());
		fabric_modifyResourcePackList(fabricResourcePacks);
		//noinspection unchecked
		return fabricResourcePacks.stream().collect(collector);
	}

	@Inject(method = "reloadResources", at = @At(value = "INVOKE", target = "Lnet/minecraft/resource/ReloadableResourceManager;beginMonitoredReload(Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture;Ljava/util/List;)Lnet/minecraft/resource/ResourceReloadMonitor;", ordinal = 0), locals = LocalCapture.CAPTURE_FAILHARD)
	public void reloadResources(CallbackInfoReturnable<CompletableFuture> info, CompletableFuture<java.lang.Void> cf, List<class_3262> list) {
		fabric_modifyResourcePackList(list);
	}
}
