/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource.loader;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.bridge.game.GameVersion;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.resource.ModResourcePack;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.fabric.impl.resource.loader.FabricModResourcePack;
import net.fabricmc.fabric.impl.resource.loader.ModNioResourcePack;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackCreator;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3288;
import net.minecraft.class_5359;
import net.minecraft.class_7701;
import net.minecraft.class_7712;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public final class ModResourcePackUtil {
    private static final Gson GSON = new Gson();

    private ModResourcePackUtil() {
    }

    public static void appendModResourcePacks(List<ModResourcePack> packs, class_3264 type, @Nullable String subPath) {
        for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
            ModNioResourcePack pack;
            if (container.getMetadata().getType().equals("builtin") || (pack = ModNioResourcePack.create(new class_2960("fabric", container.getMetadata().getId()), ModResourcePackUtil.getName(container.getMetadata()), container, null, type, ResourcePackActivationType.ALWAYS_ENABLED)) == null) continue;
            packs.add(pack);
        }
    }

    public static boolean containsDefault(ModMetadata info, String filename) {
        return "pack.mcmeta".equals(filename);
    }

    public static InputStream openDefault(ModMetadata info, class_3264 type, String filename) {
        switch (filename) {
            case "pack.mcmeta": {
                String description = Objects.requireNonNullElse(info.getName(), "");
                String metadata = ModResourcePackUtil.serializeMetadata(type.method_31438((GameVersion)class_155.method_16673()), description);
                return IOUtils.toInputStream((String)metadata, (Charset)Charsets.UTF_8);
            }
        }
        return null;
    }

    public static String serializeMetadata(int packVersion, String description) {
        JsonObject pack = new JsonObject();
        pack.addProperty("pack_format", (Number)packVersion);
        pack.addProperty("description", description);
        JsonObject metadata = new JsonObject();
        metadata.add("pack", (JsonElement)pack);
        return GSON.toJson((JsonElement)metadata);
    }

    public static class_2561 getName(ModMetadata info) {
        if (info.getName() != null) {
            return class_2561.method_43470((String)info.getName());
        }
        return class_2561.method_43469((String)"pack.name.fabricMod", (Object[])new Object[]{info.getId()});
    }

    public static class_7712 createDefaultDataConfiguration() {
        ModResourcePackCreator modResourcePackCreator = new ModResourcePackCreator(class_3264.field_14190);
        ArrayList moddedResourcePacks = new ArrayList();
        modResourcePackCreator.method_14453(moddedResourcePacks::add);
        ArrayList<String> enabled = new ArrayList<String>(class_5359.field_25393.method_29547());
        ArrayList<String> disabled = new ArrayList<String>(class_5359.field_25393.method_29550());
        for (class_3288 profile : moddedResourcePacks) {
            class_3262 pack = profile.method_14458();
            try {
                if (pack instanceof FabricModResourcePack || pack instanceof ModNioResourcePack && ((ModNioResourcePack)pack).getActivationType().isEnabledByDefault()) {
                    enabled.add(profile.method_14463());
                    continue;
                }
                disabled.add(profile.method_14463());
            }
            finally {
                if (pack == null) continue;
                pack.close();
            }
        }
        return new class_7712(new class_5359(enabled, disabled), class_7701.field_40183);
    }
}

