/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.resource.loader;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.resource.ModResourcePack;
import net.minecraft.class_3262;
import net.minecraft.class_3288;
import net.minecraft.class_8614;

public record ModResourcePackFactory(ModResourcePack pack) implements class_3288.class_7680 {
	@Override
	public class_3262 method_52424(String name) {
		return pack;
	}

	@Override
	public class_3262 method_52425(String name, class_3288.class_7679 metadata) {
		if (metadata.comp_1584().isEmpty()) {
			return pack;
		} else {
			List<class_3262> overlays = new ArrayList<>(metadata.comp_1584().size());

			for (String overlay : metadata.comp_1584()) {
				overlays.add(pack.createOverlay(overlay));
			}

			return new class_8614(pack, overlays);
		}
	}
}
