/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource.loader;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.resource.ModResourcePack;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackCreator;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackUtil;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_4239;
import net.minecraft.class_5250;
import net.minecraft.class_7367;
import net.minecraft.class_9224;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModNioResourcePack
implements class_3262,
ModResourcePack {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModNioResourcePack.class);
    private static final Pattern RESOURCE_PACK_PATH = Pattern.compile("[a-z0-9-_.]+");
    private static final FileSystem DEFAULT_FS = FileSystems.getDefault();
    private final String id;
    private final ModContainer mod;
    private final List<Path> basePaths;
    private final class_3264 type;
    private final ResourcePackActivationType activationType;
    private final Map<class_3264, Set<String>> namespaces;
    private final class_9224 metadata;
    private final boolean modBundled;
    private static final String resPrefix = class_3264.field_14188.method_14413() + "/";
    private static final String dataPrefix = class_3264.field_14190.method_14413() + "/";

    public static ModNioResourcePack create(String id, ModContainer mod, String subPath, class_3264 type, ResourcePackActivationType activationType, boolean modBundled) {
        ArrayList<Path> paths;
        ArrayList<Path> rootPaths = mod.getRootPaths();
        if (subPath == null) {
            paths = rootPaths;
        } else {
            paths = new ArrayList<Path>(rootPaths.size());
            for (Path path : rootPaths) {
                Path childPath = (path = path.toAbsolutePath().normalize()).resolve(subPath.replace("/", path.getFileSystem().getSeparator())).normalize();
                if (!childPath.startsWith(path) || !ModNioResourcePack.exists(childPath)) continue;
                paths.add(childPath);
            }
        }
        if (paths.isEmpty()) {
            return null;
        }
        String packId = subPath == null ? id : id + "_" + subPath;
        class_5250 displayName = subPath == null ? class_2561.method_43469((String)"pack.name.fabricMod", (Object[])new Object[]{mod.getMetadata().getName()}) : class_2561.method_43469((String)"pack.name.fabricMod.subPack", (Object[])new Object[]{mod.getMetadata().getName(), class_2561.method_43471((String)("resourcePack." + subPath + ".name"))});
        class_9224 metadata = new class_9224(packId, (class_2561)displayName, ModResourcePackCreator.RESOURCE_PACK_SOURCE, Optional.empty());
        ModNioResourcePack ret = new ModNioResourcePack(packId, mod, paths, type, activationType, modBundled, metadata);
        return ret.method_14406(type).isEmpty() ? null : ret;
    }

    private ModNioResourcePack(String id, ModContainer mod, List<Path> paths, class_3264 type, ResourcePackActivationType activationType, boolean modBundled, class_9224 metadata) {
        this.id = id;
        this.mod = mod;
        this.basePaths = paths;
        this.type = type;
        this.activationType = activationType;
        this.modBundled = modBundled;
        this.namespaces = ModNioResourcePack.readNamespaces(paths, mod.getMetadata().getId());
        this.metadata = metadata;
    }

    @Override
    public ModNioResourcePack createOverlay(String overlay) {
        return new ModNioResourcePack(this.id, this.mod, this.basePaths.stream().map(path -> path.resolve(overlay)).toList(), this.type, this.activationType, this.modBundled, this.metadata);
    }

    static Map<class_3264, Set<String>> readNamespaces(List<Path> paths, String modId) {
        EnumMap<class_3264, Set<String>> ret = new EnumMap<class_3264, Set<String>>(class_3264.class);
        for (class_3264 type : class_3264.values()) {
            Set namespaces = null;
            for (Path path : paths) {
                Path dir = path.resolve(type.method_14413());
                if (!Files.isDirectory(dir, new LinkOption[0])) continue;
                String separator = path.getFileSystem().getSeparator();
                try {
                    DirectoryStream<Path> ds = Files.newDirectoryStream(dir);
                    try {
                        for (Path p : ds) {
                            if (!Files.isDirectory(p, new LinkOption[0])) continue;
                            String s = p.getFileName().toString();
                            if (!RESOURCE_PACK_PATH.matcher(s = s.replace(separator, "")).matches()) {
                                LOGGER.warn("Fabric NioResourcePack: ignored invalid namespace: {} in mod ID {}", (Object)s, (Object)modId);
                                continue;
                            }
                            if (namespaces == null) {
                                namespaces = new HashSet();
                            }
                            namespaces.add(s);
                        }
                    }
                    finally {
                        if (ds == null) continue;
                        ds.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("getNamespaces in mod " + modId + " failed!", (Throwable)e);
                }
            }
            ret.put(type, namespaces != null ? namespaces : Collections.emptySet());
        }
        return ret;
    }

    private Path getPath(String filename) {
        if (this.hasAbsentNs(filename)) {
            return null;
        }
        for (Path basePath : this.basePaths) {
            Path childPath = basePath.resolve(filename.replace("/", basePath.getFileSystem().getSeparator())).toAbsolutePath().normalize();
            if (!childPath.startsWith(basePath) || !ModNioResourcePack.exists(childPath)) continue;
            return childPath;
        }
        return null;
    }

    private boolean hasAbsentNs(String filename) {
        class_3264 type;
        int prefixLen;
        if (filename.startsWith(resPrefix)) {
            prefixLen = resPrefix.length();
            type = class_3264.field_14188;
        } else if (filename.startsWith(dataPrefix)) {
            prefixLen = dataPrefix.length();
            type = class_3264.field_14190;
        } else {
            return false;
        }
        int nsEnd = filename.indexOf(47, prefixLen);
        if (nsEnd < 0) {
            return false;
        }
        return !this.namespaces.get(type).contains(filename.substring(prefixLen, nsEnd));
    }

    private class_7367<InputStream> openFile(String filename) {
        Path path = this.getPath(filename);
        if (path != null && Files.isRegularFile(path, new LinkOption[0])) {
            return () -> Files.newInputStream(path, new OpenOption[0]);
        }
        if (ModResourcePackUtil.containsDefault(filename, this.modBundled)) {
            return () -> ModResourcePackUtil.openDefault(this.mod, this.type, filename);
        }
        return null;
    }

    @Nullable
    public class_7367<InputStream> method_14410(String ... pathSegments) {
        class_4239.method_46345((String[])pathSegments);
        return this.openFile(String.join((CharSequence)"/", pathSegments));
    }

    @Nullable
    public class_7367<InputStream> method_14405(class_3264 type, class_2960 id) {
        Path path = this.getPath(ModNioResourcePack.getFilename(type, id));
        return path == null ? null : class_7367.create((Path)path);
    }

    public void method_14408(class_3264 type, final String namespace, String path, final class_3262.class_7664 visitor) {
        if (!this.namespaces.getOrDefault(type, Collections.emptySet()).contains(namespace)) {
            return;
        }
        for (Path basePath : this.basePaths) {
            final String separator = basePath.getFileSystem().getSeparator();
            final Path nsPath = basePath.resolve(type.method_14413()).resolve(namespace);
            Path searchPath = nsPath.resolve(path.replace("/", separator)).normalize();
            if (!ModNioResourcePack.exists(searchPath)) continue;
            try {
                Files.walkFileTree(searchPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        String filename = nsPath.relativize(file).toString().replace(separator, "/");
                        class_2960 identifier = class_2960.method_43902((String)namespace, (String)filename);
                        if (identifier == null) {
                            LOGGER.error("Invalid path in mod resource-pack {}: {}:{}, ignoring", new Object[]{ModNioResourcePack.this.id, namespace, filename});
                        } else {
                            visitor.accept((Object)identifier, (Object)class_7367.create((Path)file));
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                LOGGER.warn("findResources at " + path + " in namespace " + namespace + ", mod " + this.mod.getMetadata().getId() + " failed!", (Throwable)e);
            }
        }
    }

    public Set<String> method_14406(class_3264 type) {
        return this.namespaces.getOrDefault(type, Collections.emptySet());
    }

    public <T> T method_14407(class_3270<T> metaReader) throws IOException {
        try (InputStream is = (InputStream)Objects.requireNonNull(this.openFile("pack.mcmeta")).get();){
            Object object = class_3255.method_14392(metaReader, (InputStream)is);
            return (T)object;
        }
    }

    public class_9224 method_56926() {
        return this.metadata;
    }

    public void close() {
    }

    @Override
    public ModMetadata getFabricModMetadata() {
        return this.mod.getMetadata();
    }

    public ResourcePackActivationType getActivationType() {
        return this.activationType;
    }

    public String method_14409() {
        return this.id;
    }

    private static boolean exists(Path path) {
        return path.getFileSystem() == DEFAULT_FS ? path.toFile().exists() : Files.exists(path, new LinkOption[0]);
    }

    private static String getFilename(class_3264 type, class_2960 id) {
        return String.format(Locale.ROOT, "%s/%s/%s", type.method_14413(), id.method_12836(), id.method_12832());
    }
}

