/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource.loader;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.resource.ModResourcePack;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.fabric.impl.resource.loader.FabricResourcePackProfile;
import net.fabricmc.fabric.impl.resource.loader.ModNioResourcePack;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackCreator;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3272;
import net.minecraft.class_3288;
import net.minecraft.class_5359;
import net.minecraft.class_7701;
import net.minecraft.class_7712;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModResourcePackUtil {
    public static final Gson GSON = new Gson();
    private static final Logger LOGGER = LoggerFactory.getLogger(ModResourcePackUtil.class);

    private ModResourcePackUtil() {
    }

    public static void appendModResourcePacks(List<ModResourcePack> packs, class_3264 type, @Nullable String subPath) {
        for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
            ModNioResourcePack pack;
            if (container.getMetadata().getType().equals("builtin") || (pack = ModNioResourcePack.create(container.getMetadata().getId(), container, subPath, type, ResourcePackActivationType.ALWAYS_ENABLED, true)) == null) continue;
            packs.add(pack);
        }
    }

    public static void refreshAutoEnabledPacks(List<class_3288> enabledProfiles, Map<String, class_3288> allProfiles) {
        LOGGER.debug("[Fabric] Starting internal pack sorting with: {}", enabledProfiles.stream().map(class_3288::method_14463).toList());
        enabledProfiles.removeIf(profile -> ((FabricResourcePackProfile)profile).fabric_isHidden());
        LOGGER.debug("[Fabric] Removed all internal packs, result: {}", enabledProfiles.stream().map(class_3288::method_14463).toList());
        ListIterator<class_3288> it = enabledProfiles.listIterator();
        LinkedHashSet<String> seen = new LinkedHashSet<String>();
        while (it.hasNext()) {
            class_3288 profile2 = it.next();
            seen.add(profile2.method_14463());
            for (class_3288 p : allProfiles.values()) {
                FabricResourcePackProfile fp = (FabricResourcePackProfile)p;
                if (!fp.fabric_isHidden() || !fp.fabric_parentsEnabled(seen) || !seen.add(p.method_14463())) continue;
                it.add(p);
                LOGGER.debug("[Fabric] cur @ {}, auto-enabled {}, currently enabled: {}", new Object[]{profile2.method_14463(), p.method_14463(), seen});
            }
        }
        LOGGER.debug("[Fabric] Final sorting result: {}", enabledProfiles.stream().map(class_3288::method_14463).toList());
    }

    public static boolean containsDefault(String filename, boolean modBundled) {
        return "pack.mcmeta".equals(filename) || modBundled && "pack.png".equals(filename);
    }

    public static InputStream getDefaultIcon() throws IOException {
        Optional loaderIconPath = FabricLoader.getInstance().getModContainer("fabric-resource-loader-v0").flatMap(resourceLoaderContainer -> resourceLoaderContainer.getMetadata().getIconPath(512).flatMap(arg_0 -> ((ModContainer)resourceLoaderContainer).findPath(arg_0)));
        if (loaderIconPath.isPresent()) {
            return Files.newInputStream((Path)loaderIconPath.get(), new OpenOption[0]);
        }
        return null;
    }

    public static InputStream openDefault(ModContainer container, class_3264 type, String filename) throws IOException {
        switch (filename) {
            case "pack.mcmeta": {
                String description = Objects.requireNonNullElse(container.getMetadata().getId(), "");
                String metadata = ModResourcePackUtil.serializeMetadata(class_155.method_16673().method_48017(type), description);
                return IOUtils.toInputStream((String)metadata, (Charset)Charsets.UTF_8);
            }
            case "pack.png": {
                Optional path = container.getMetadata().getIconPath(512).flatMap(arg_0 -> ((ModContainer)container).findPath(arg_0));
                if (path.isPresent()) {
                    return Files.newInputStream((Path)path.get(), new OpenOption[0]);
                }
                return ModResourcePackUtil.getDefaultIcon();
            }
        }
        return null;
    }

    public static class_3272 getMetadataPack(int packVersion, class_2561 description) {
        return new class_3272(description, packVersion, Optional.empty());
    }

    public static JsonObject getMetadataPackJson(int packVersion, class_2561 description) {
        return class_3272.field_14202.method_45251((Object)ModResourcePackUtil.getMetadataPack(packVersion, description));
    }

    public static String serializeMetadata(int packVersion, String description) {
        JsonObject pack = ModResourcePackUtil.getMetadataPackJson(packVersion, (class_2561)class_2561.method_43470((String)description));
        JsonObject metadata = new JsonObject();
        metadata.add("pack", (JsonElement)pack);
        return GSON.toJson((JsonElement)metadata);
    }

    public static class_2561 getName(ModMetadata info) {
        if (info.getId() != null) {
            return class_2561.method_43470((String)info.getId());
        }
        return class_2561.method_43469((String)"pack.name.fabricMod", (Object[])new Object[]{info.getId()});
    }

    public static class_7712 createDefaultDataConfiguration() {
        ModResourcePackCreator modResourcePackCreator = new ModResourcePackCreator(class_3264.field_14190);
        ArrayList moddedResourcePacks = new ArrayList();
        modResourcePackCreator.method_14453(moddedResourcePacks::add);
        ArrayList<String> enabled = new ArrayList<String>(class_5359.field_25393.method_29547());
        ArrayList<String> disabled = new ArrayList<String>(class_5359.field_25393.method_29550());
        for (class_3288 profile : moddedResourcePacks) {
            if (profile.method_29483() == ModResourcePackCreator.RESOURCE_PACK_SOURCE) {
                enabled.add(profile.method_14463());
                continue;
            }
            class_3262 pack = profile.method_14458();
            try {
                if (pack instanceof ModNioResourcePack && ((ModNioResourcePack)pack).getActivationType().isEnabledByDefault()) {
                    enabled.add(profile.method_14463());
                    continue;
                }
                disabled.add(profile.method_14463());
            }
            finally {
                if (pack == null) continue;
                pack.close();
            }
        }
        return new class_7712(new class_5359(enabled, disabled), class_7701.field_40183);
    }

    public static class_5359 createTestServerSettings(List<String> enabled, List<String> disabled) {
        HashSet moddedProfiles = new HashSet();
        ModResourcePackCreator modResourcePackCreator = new ModResourcePackCreator(class_3264.field_14190);
        modResourcePackCreator.method_14453(profile -> moddedProfiles.add(profile.method_14463()));
        ArrayList<String> moveToTheEnd = new ArrayList<String>();
        Iterator<String> it = enabled.iterator();
        while (it.hasNext()) {
            String profile2 = it.next();
            if (!moddedProfiles.contains(profile2)) continue;
            moveToTheEnd.add(profile2);
            it.remove();
        }
        enabled.addAll(moveToTheEnd);
        return new class_5359(enabled, disabled);
    }
}

