/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.client.resource.loader;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;

import org.jetbrains.annotations.Nullable;
import net.fabricmc.fabric.api.resource.ModResourcePack;
import net.fabricmc.fabric.impl.resource.loader.GroupResourcePack;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_4239;
import net.minecraft.class_7367;

/**
 * Represents a vanilla built-in resource pack with support for modded content.
 *
 * <p>Vanilla resources are provided as usual through the original resource pack,
 * all other resources will be searched for in the provided modded resource packs.</p>
 */
public class FabricWrappedVanillaResourcePack extends GroupResourcePack {
	private final class_3255 originalResourcePack;

	public FabricWrappedVanillaResourcePack(class_3255 originalResourcePack, List<ModResourcePack> modResourcePacks) {
		super(class_3264.field_14188, modResourcePacks);
		this.originalResourcePack = originalResourcePack;
	}

	@Override
	public class_7367<InputStream> method_14410(String... pathSegments) {
		class_4239.method_46345(pathSegments);

		return this.originalResourcePack.method_14410(String.join("/", pathSegments));
	}

	@Override
	public class_7367<InputStream> method_14405(class_3264 type, class_2960 id) {
		class_7367<InputStream> originalPackData = this.originalResourcePack.method_14405(type, id);

		if (originalPackData != null) {
			return originalPackData;
		}

		return super.method_14405(type, id);
	}

	@Override
	public void method_14408(class_3264 type, String namespace, String prefix, class_7664 consumer) {
		super.method_14408(type, namespace, prefix, consumer);
		this.originalResourcePack.method_14408(type, namespace, prefix, consumer);
	}

	@Override
	public Set<String> method_14406(class_3264 type) {
		Set<String> namespaces = this.originalResourcePack.method_14406(type);

		namespaces.addAll(super.method_14406(type));

		return namespaces;
	}

	@Override
	public <T> @Nullable T method_14407(class_3270<T> metaReader) throws IOException {
		return this.originalResourcePack.method_14407(metaReader);
	}

	@Override
	public String method_14409() {
		return this.originalResourcePack.method_14409();
	}

	@Override
	public void close() {
		this.originalResourcePack.close();
		super.close();
	}
}
