/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource.loader;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.impl.resource.loader.ModNioResourcePack;
import net.fabricmc.fabric.mixin.resource.loader.MixinFormat4ResourcePack;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_155;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3268;
import net.minecraft.class_4729;
import org.apache.commons.io.IOUtils;

public final class ModResourcePackUtil {
    public static final int PACK_FORMAT_VERSION = class_155.method_16673().getPackVersion();

    private ModResourcePackUtil() {
    }

    public static void appendModResourcePacks(List<class_3262> packList, class_3264 type) {
        for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
            if (container.getMetadata().getType().equals("builtin")) continue;
            Path path = container.getRootPath();
            ModNioResourcePack pack = new ModNioResourcePack(container.getMetadata(), path, null);
            if (pack.method_14406(type).isEmpty()) continue;
            packList.add(pack);
        }
    }

    public static boolean containsDefault(ModMetadata info, String filename) {
        return "pack.mcmeta".equals(filename);
    }

    public static InputStream openDefault(ModMetadata info, String filename) {
        switch (filename) {
            case "pack.mcmeta": {
                String description = info.getName();
                description = description == null ? "" : description.replaceAll("\"", "\\\"");
                String pack = String.format("{\"pack\":{\"pack_format\":" + PACK_FORMAT_VERSION + ",\"description\":\"%s\"}}", description);
                return IOUtils.toInputStream((String)pack, (Charset)Charsets.UTF_8);
            }
        }
        return null;
    }

    public static String getName(ModMetadata info) {
        if (info.getName() != null) {
            return info.getName();
        }
        return "Fabric Mod \"" + info.getId() + "\"";
    }

    public static void modifyResourcePackList(List<class_3262> list) {
        ArrayList oldList = Lists.newArrayList(list);
        list.clear();
        boolean appended = false;
        for (int i = 0; i < oldList.size(); ++i) {
            class_3262 pack = (class_3262)oldList.get(i);
            list.add(pack);
            boolean isDefaultResources = pack instanceof class_3268;
            if (!isDefaultResources && pack instanceof class_4729) {
                MixinFormat4ResourcePack fixer = (MixinFormat4ResourcePack)pack;
                isDefaultResources = fixer.getParent() instanceof class_3268;
            }
            if (!isDefaultResources) continue;
            ModResourcePackUtil.appendModResourcePacks(list, class_3264.field_14188);
            appended = true;
        }
        if (!appended) {
            StringBuilder builder = new StringBuilder("Fabric could not find resource pack injection location!");
            for (class_3262 rp : oldList) {
                builder.append("\n - ").append(rp.method_14409()).append(" (").append(rp.getClass().getName()).append(")");
            }
            throw new RuntimeException(builder.toString());
        }
    }
}

