/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.resource.loader;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.resource.ModResourcePack;
import net.minecraft.class_2588;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3285;
import net.minecraft.class_3288;
import net.minecraft.class_5352;

public class ModResourcePackCreator implements class_3285 {
	public static final class_5352 RESOURCE_PACK_SOURCE = text -> new class_2588("pack.nameAndSource", text, new class_2588("pack.source.fabricmod"));
	private final class_3264 type;

	public ModResourcePackCreator(class_3264 type) {
		this.type = type;
	}

	@Override
	public void method_14453(Consumer<class_3288> consumer, class_3288.class_5351 factory) {
		// TODO: "vanilla" does not emit a message; neither should a modded datapack
		List<class_3262> packs = new ArrayList<>();
		ModResourcePackUtil.appendModResourcePacks(packs, type);

		for (class_3262 pack : packs) {
			if (!(pack instanceof ModResourcePack)) {
				throw new RuntimeException("Not a ModResourcePack!");
			}

			class_3288 resourcePackProfile = class_3288.method_14456("fabric/" + ((ModResourcePack) pack).getFabricModMetadata().getId(),
					false, () -> pack, factory, class_3288.class_3289.field_14280,
					RESOURCE_PACK_SOURCE);

			if (resourcePackProfile != null) {
				consumer.accept(resourcePackProfile);
			}
		}
	}
}
