/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource.loader;

import com.google.common.collect.Lists;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.impl.resource.loader.ModNioResourcePack;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3288;
import net.minecraft.class_3302;
import net.minecraft.class_3545;
import net.minecraft.class_5352;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceManagerHelperImpl
implements ResourceManagerHelper {
    private static final Map<class_3264, ResourceManagerHelperImpl> registryMap = new HashMap<class_3264, ResourceManagerHelperImpl>();
    private static final Set<class_3545<String, ModNioResourcePack>> builtinResourcePacks = new HashSet<class_3545<String, ModNioResourcePack>>();
    private static final Logger LOGGER = LogManager.getLogger();
    private final Set<class_2960> addedListenerIds = new HashSet<class_2960>();
    private final Set<IdentifiableResourceReloadListener> addedListeners = new LinkedHashSet<IdentifiableResourceReloadListener>();

    public static ResourceManagerHelper get(class_3264 type) {
        return registryMap.computeIfAbsent(type, t -> new ResourceManagerHelperImpl());
    }

    public static boolean registerBuiltinResourcePack(class_2960 id, String subPath, ModContainer container, boolean enabledByDefault) {
        String separator = container.getRootPath().getFileSystem().getSeparator();
        subPath = subPath.replace("/", separator);
        Path resourcePackPath = container.getRootPath().resolve(subPath).toAbsolutePath().normalize();
        if (!Files.exists(resourcePackPath, new LinkOption[0])) {
            return false;
        }
        String name = id.method_12836() + "/" + id.method_12832();
        builtinResourcePacks.add((class_3545<String, ModNioResourcePack>)new class_3545((Object)name, (Object)new ModNioResourcePack(container.getMetadata(), resourcePackPath, class_3264.field_14188, null, name, enabledByDefault)));
        builtinResourcePacks.add((class_3545<String, ModNioResourcePack>)new class_3545((Object)name, (Object)new ModNioResourcePack(container.getMetadata(), resourcePackPath, class_3264.field_14190, null, name, enabledByDefault)));
        return true;
    }

    public static void registerBuiltinResourcePacks(class_3264 resourceType, Consumer<class_3288> consumer, class_3288.class_5351 factory) {
        for (class_3545<String, ModNioResourcePack> entry : builtinResourcePacks) {
            if (((ModNioResourcePack)entry.method_15441()).method_14406(resourceType).isEmpty()) continue;
            class_3288 profile = class_3288.method_14456((String)((String)entry.method_15442()), (boolean)false, () -> entry.method_15441(), (class_3288.class_5351)factory, (class_3288.class_3289)class_3288.class_3289.field_14280, (class_5352)class_5352.field_25348);
            if (profile == null) continue;
            consumer.accept(profile);
        }
    }

    public static void sort(class_3264 type, List<class_3302> listeners) {
        ResourceManagerHelperImpl instance = registryMap.get(type);
        if (instance != null) {
            instance.sort(listeners);
        }
    }

    protected void sort(List<class_3302> listeners) {
        listeners.removeAll(this.addedListeners);
        ArrayList listenersToAdd = Lists.newArrayList(this.addedListeners);
        HashSet<class_2960> resolvedIds = new HashSet<class_2960>();
        for (class_3302 listener : listeners) {
            if (!(listener instanceof IdentifiableResourceReloadListener)) continue;
            resolvedIds.add(((IdentifiableResourceReloadListener)listener).getFabricId());
        }
        int lastSize = -1;
        while (listeners.size() != lastSize) {
            lastSize = listeners.size();
            Iterator it = listenersToAdd.iterator();
            while (it.hasNext()) {
                IdentifiableResourceReloadListener listener = (IdentifiableResourceReloadListener)it.next();
                if (!resolvedIds.containsAll(listener.getFabricDependencies())) continue;
                resolvedIds.add(listener.getFabricId());
                listeners.add(listener);
                it.remove();
            }
        }
        for (IdentifiableResourceReloadListener listener : listenersToAdd) {
            LOGGER.warn("Could not resolve dependencies for listener: " + listener.getFabricId() + "!");
        }
    }

    @Override
    public void registerReloadListener(IdentifiableResourceReloadListener listener) {
        if (!this.addedListenerIds.add(listener.getFabricId())) {
            LOGGER.warn("Tried to register resource reload listener " + listener.getFabricId() + " twice!");
            return;
        }
        if (!this.addedListeners.add(listener)) {
            throw new RuntimeException("Listener with previously unknown ID " + listener.getFabricId() + " already in listener set!");
        }
    }
}

