/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.resource.loader;

import java.util.Collection;
import java.util.Collections;
import java.util.Locale;

import org.spongepowered.asm.mixin.Mixin;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceReloadListenerKeys;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_2989;
import net.minecraft.class_2991;
import net.minecraft.class_3505;
import net.minecraft.class_60;

@Mixin({
		/* public */
		class_1863.class, class_2989.class, class_2991.class, class_60.class, class_3505.class
		/* private */
})
public abstract class KeyedResourceReloadListenerMixin implements IdentifiableResourceReloadListener {
	private class_2960 fabric$id;
	private Collection<class_2960> fabric$dependencies;

	@Override
	@SuppressWarnings({"ConstantConditions", "RedundantCast"})
	public class_2960 getFabricId() {
		if (this.fabric$id == null) {
			Object self = this;

			if (self instanceof class_1863) {
				this.fabric$id = ResourceReloadListenerKeys.RECIPES;
			} else if (self instanceof class_2989) {
				this.fabric$id = ResourceReloadListenerKeys.ADVANCEMENTS;
			} else if (self instanceof class_2991) {
				this.fabric$id = ResourceReloadListenerKeys.FUNCTIONS;
			} else if (self instanceof class_60) {
				this.fabric$id = ResourceReloadListenerKeys.LOOT_TABLES;
			} else if (self instanceof class_3505) {
				this.fabric$id = ResourceReloadListenerKeys.TAGS;
			} else {
				this.fabric$id = new class_2960("minecraft", "private/" + self.getClass().getSimpleName().toLowerCase(Locale.ROOT));
			}
		}

		return this.fabric$id;
	}

	@Override
	@SuppressWarnings({"ConstantConditions", "RedundantCast"})
	public Collection<class_2960> getFabricDependencies() {
		if (this.fabric$dependencies == null) {
			Object self = this;

			if (self instanceof class_3505) {
				this.fabric$dependencies = Collections.emptyList();
			} else {
				this.fabric$dependencies = Collections.singletonList(ResourceReloadListenerKeys.TAGS);
			}
		}

		return this.fabric$dependencies;
	}
}
